/*
 * Decompiled with CFR 0.152.
 */
package prompto.store;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import prompto.code.ICodeStore;
import prompto.intrinsic.PromptoDbId;
import prompto.intrinsic.PromptoList;
import prompto.parser.Dialect;
import prompto.runtime.ApplicationContext;
import prompto.server.HeadlessTests;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.IAuditMetadata;
import prompto.store.IAuditRecord;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.TestRemoteStoreBase;
import prompto.store.memory.MemStore;

@Category(value={HeadlessTests.class})
public class TestRemoteMemStore
extends TestRemoteStoreBase {
    @Override
    protected IStore getDataStore() {
        return new MemStore(() -> true);
    }

    @Test
    public void insertIsAudited() throws Exception {
        this.linkResourcesAndLoadPage("InsertIsAudited", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
        IQueryBuilder builder = DataStore.getInstance().newQueryBuilder();
        AttributeInfo info = ICodeStore.getInstance().fetchAttributeInfo(ApplicationContext.get(), "value");
        builder.verify(info, IQueryBuilder.MatchOp.EQUALS, (Object)"John");
        IStored stored = DataStore.getInstance().fetchOne(builder.build());
        Assert.assertNotNull((Object)stored);
        PromptoDbId metadataId = DataStore.getInstance().fetchLatestAuditMetadataId(stored.getDbId());
        Assert.assertNotNull((Object)metadataId);
        IAuditMetadata metadata = DataStore.getInstance().fetchAuditMetadata(metadataId);
        Assert.assertEquals((Object)"Hello", (Object)metadata.get((Object)"message"));
        IAuditRecord record = DataStore.getInstance().fetchLatestAuditRecord(stored.getDbId());
        Assert.assertEquals((Object)IAuditRecord.Operation.INSERT, (Object)record.getOperation());
    }

    @Test
    public void updateIsAudited() throws Exception {
        this.linkResourcesAndLoadPage("UpdateIsAudited", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
        IQueryBuilder builder = DataStore.getInstance().newQueryBuilder();
        AttributeInfo info = ICodeStore.getInstance().fetchAttributeInfo(ApplicationContext.get(), "value");
        builder.verify(info, IQueryBuilder.MatchOp.EQUALS, (Object)"John");
        IStored stored = DataStore.getInstance().fetchOne(builder.build());
        Assert.assertNotNull((Object)stored);
        PromptoDbId metadataId = DataStore.getInstance().fetchLatestAuditMetadataId(stored.getDbId());
        Assert.assertNotNull((Object)metadataId);
        IAuditMetadata metadata = DataStore.getInstance().fetchAuditMetadata(metadataId);
        Assert.assertEquals((Object)"Hello", (Object)metadata.get((Object)"message"));
        IAuditRecord record = DataStore.getInstance().fetchLatestAuditRecord(stored.getDbId());
        Assert.assertEquals((Object)IAuditRecord.Operation.UPDATE, (Object)record.getOperation());
    }

    @Test
    public void deleteIsAudited() throws Exception {
        this.linkResourcesAndLoadPage("DeleteIsAudited", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
        PromptoList records = DataStore.getInstance().fetchAuditRecordsMatching(Collections.singletonMap("operation", "DELETE"), null);
        Assert.assertEquals((long)1L, (long)records.size());
        IAuditRecord record = (IAuditRecord)records.get(0);
        Assert.assertEquals((Object)IAuditRecord.Operation.DELETE, (Object)record.getOperation());
        IAuditMetadata metadata = DataStore.getInstance().fetchAuditMetadata(record.getMetadataDbId());
        Assert.assertEquals((Object)"Hello", (Object)metadata.get((Object)"message"));
    }

    @Test
    public void auditIsEnabled() throws Exception {
        this.linkResourcesAndLoadPage("AuditIsEnabled", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"true", (Object)elem.getText());
    }

    @Test
    public void FetchesLatestAuditMetadataId() throws Exception {
        this.linkResourcesAndLoadPage("FetchesLatestAuditMetadataId", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"true", (Object)elem.getText());
    }

    @Test
    public void allAuditMetadataIdsAreFetched() throws Exception {
        this.linkResourcesAndLoadPage("AllAuditMetadataIdsAreFetched", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"3", (Object)elem.getText());
    }

    @Test
    public void fetchesAuditMetadata() throws Exception {
        this.linkResourcesAndLoadPage("FetchesAuditMetadata", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Albert", (Object)elem.getText());
    }

    @Test
    public void fetchesDbIdsAffectedByAuditMetadataId() throws Exception {
        this.linkResourcesAndLoadPage("FetchesDbIdsAffectedByAuditMetadataId", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"/e1:true/e2:true", (Object)elem.getText());
    }

    @Test
    public void fetchesLatestAuditRecord() throws Exception {
        this.linkResourcesAndLoadPage("FetchesLatestAuditRecord", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"INSERT", (Object)elem.getText());
    }

    @Test
    public void fetchesAllAuditRecords() throws Exception {
        this.linkResourcesAndLoadPage("FetchesAllAuditRecords", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"UPDATE/INSERT", (Object)elem.getText());
    }

    @Test
    public void deletesAuditRecord() throws Exception {
        this.linkResourcesAndLoadPage("DeletesAuditRecord", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"/false/true", (Object)elem.getText());
    }

    @Test
    public void deletesAuditMetadata() throws Exception {
        this.linkResourcesAndLoadPage("DeletesAuditMetadata", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"/false/true", (Object)elem.getText());
    }

    @Test
    public void fetchesAuditRecordsMatching() throws Exception {
        this.linkResourcesAndLoadPage("FetchesAuditRecordsMatching", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"/INSERT", (Object)elem.getText());
    }
}

