/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.debug.IDebugger;
import prompto.debug.Serializer;
import prompto.debug.request.IDebugRequest;
import prompto.debug.response.IDebugResponse;
import prompto.server.CleverServlet;

public class DebugRequestServlet
extends CleverServlet {
    IDebugger debugger;

    public void setDebugger(IDebugger debugger) {
        this.debugger = debugger;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block9: {
            try (ServletOutputStream stream = resp.getOutputStream();){
                try {
                    String contentType = req.getContentType();
                    if (contentType.startsWith("application/json")) {
                        this.doPostJson(req, resp, (OutputStream)stream);
                        break block9;
                    }
                    resp.sendError(415);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    resp.setStatus(500);
                    this.writeJSONError(t.getMessage(), stream);
                }
            }
        }
    }

    private void doPostJson(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws Exception {
        try (ServletInputStream input = req.getInputStream();){
            IDebugRequest request = Serializer.readDebugRequest((InputStream)input);
            IDebugResponse response = request.execute(this.debugger);
            resp.setContentType("application/json;charset=utf-8");
            Serializer.writeMessage((OutputStream)output, (Object)response);
        }
    }
}

