/*
 * Decompiled with CFR 0.152.
 */
package prompto.graphql;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.expression.Symbol;
import prompto.grammar.Identifier;
import prompto.graphql.GraphQLAttributeFetcher;
import prompto.graphql.GraphQLScalars;
import prompto.runtime.ApplicationContext;
import prompto.type.CategoryType;
import prompto.type.CursorType;
import prompto.type.IType;
import prompto.type.ListType;

public interface GraphQLType {
    public static final Map<String, GraphQLType> TYPE_BY_NAME_MAP = new HashMap<String, GraphQLType>();

    public static GraphQLInputType buildInputType(IType type, GraphQLCodeRegistry.Builder registry) {
        if (GraphQLScalars.isScalar(type)) {
            return GraphQLScalars.get(type);
        }
        return GraphQLType.build(type, registry).inputType();
    }

    public static GraphQLOutputType buildOutputType(IType type, GraphQLCodeRegistry.Builder registry) {
        if (GraphQLScalars.isScalar(type)) {
            return GraphQLScalars.get(type);
        }
        return GraphQLType.build(type, registry).outputType();
    }

    public GraphQLInputType inputType();

    public GraphQLOutputType outputType();

    public IType reflectedType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphQLType build(IType type, GraphQLCodeRegistry.Builder registry) {
        Map<String, GraphQLType> map = TYPE_BY_NAME_MAP;
        synchronized (map) {
            if (!TYPE_BY_NAME_MAP.containsKey(type.getTypeName())) {
                TYPE_BY_NAME_MAP.put(type.getTypeName(), null);
                GraphQLType gql = GraphQLType.doBuild(type, registry);
                TYPE_BY_NAME_MAP.put(type.getTypeName(), gql);
            }
            return TYPE_BY_NAME_MAP.get(type.getTypeName());
        }
    }

    public static GraphQLType doBuild(final IType type, final GraphQLCodeRegistry.Builder registry) {
        return new GraphQLType(){
            GraphQLInputType _input;
            GraphQLOutputType _output;

            @Override
            public IType reflectedType() {
                return type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GraphQLInputType inputType() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this._input == null) {
                        this._input = this._buildInputType(type, registry);
                    }
                    return this._input;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GraphQLOutputType outputType() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this._output == null) {
                        this._output = this._buildOutputType(type, registry);
                    }
                    return this._output;
                }
            }

            private GraphQLOutputType _buildOutputType(IType type2, GraphQLCodeRegistry.Builder registry2) {
                if (type2 instanceof CursorType) {
                    return this._buildOutputCursorType((CursorType)type2, registry2);
                }
                if (type2 instanceof CategoryType) {
                    return this._buildOutputCategoryType((CategoryType)type2, registry2);
                }
                if (type2 instanceof ListType) {
                    GraphQLOutputType itemType = GraphQLType.buildOutputType(((ListType)type2).getItemType(), registry2);
                    return GraphQLList.list((graphql.schema.GraphQLType)itemType);
                }
                throw new UnsupportedOperationException("yet!");
            }

            private GraphQLOutputType _buildOutputCursorType(CursorType type2, GraphQLCodeRegistry.Builder registry2) {
                GraphQLOutputType itemType = GraphQLType.buildOutputType(type2.getItemType(), registry2);
                return GraphQLObjectType.newObject().name(type2.getItemType().getTypeName() + "Cursor").field(GraphQLFieldDefinition.newFieldDefinition().name("count").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("totalCount").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("items").type((GraphQLOutputType)GraphQLList.list((graphql.schema.GraphQLType)itemType)).build()).build();
            }

            private GraphQLOutputType _buildOutputCategoryType(CategoryType type2, GraphQLCodeRegistry.Builder registry2) {
                IDeclaration decl = ApplicationContext.get().getRegisteredDeclaration(IDeclaration.class, type2.getTypeNameId());
                if (decl instanceof CategoryDeclaration) {
                    return this._buildOutputCategoryType((CategoryDeclaration)decl, registry2);
                }
                if (decl instanceof IEnumeratedDeclaration) {
                    return this._buildOutputEnumeratedType((IEnumeratedDeclaration)decl, registry2);
                }
                throw new UnsupportedOperationException("Yet!");
            }

            private GraphQLOutputType _buildOutputCategoryType(CategoryDeclaration decl, GraphQLCodeRegistry.Builder registry2) {
                return GraphQLObjectType.newObject().name(type.getTypeName()).fields(this._buildOutputFields(decl, registry2)).build();
            }

            private GraphQLOutputType _buildOutputEnumeratedType(IEnumeratedDeclaration<?> decl, GraphQLCodeRegistry.Builder registry2) {
                return GraphQLEnumType.newEnum().name(type.getTypeName()).values(this._buildEnumValues(decl)).build();
            }

            private List<GraphQLEnumValueDefinition> _buildEnumValues(IEnumeratedDeclaration<?> decl) {
                return decl.getSymbolsList().stream().map(this::_buildEnumValue).collect(Collectors.toList());
            }

            private GraphQLEnumValueDefinition _buildEnumValue(Symbol symbol) {
                return GraphQLEnumValueDefinition.newEnumValueDefinition().name(symbol.getName()).value((Object)symbol).build();
            }

            private List<GraphQLFieldDefinition> _buildOutputFields(CategoryDeclaration decl, GraphQLCodeRegistry.Builder registry2) {
                return decl.getAllAttributes(ApplicationContext.get()).stream().map(attr -> this._buildOutputField(decl, (Identifier)attr, registry2)).filter(Objects::nonNull).collect(Collectors.toList());
            }

            private GraphQLFieldDefinition _buildOutputField(CategoryDeclaration category, Identifier attr, GraphQLCodeRegistry.Builder registry2) {
                registry2.dataFetcherIfAbsent(FieldCoordinates.coordinates((String)category.getName(), (String)attr.toString()), (DataFetcher)new GraphQLAttributeFetcher(attr));
                AttributeDeclaration decl = (AttributeDeclaration)ApplicationContext.get().getRegisteredDeclaration(AttributeDeclaration.class, attr);
                return GraphQLFieldDefinition.newFieldDefinition().name(attr.toString()).type(GraphQLType.buildOutputType(decl.getType(), registry2)).build();
            }

            private GraphQLInputType _buildInputType(IType type2, GraphQLCodeRegistry.Builder registry2) {
                if (!(type2 instanceof CategoryType)) {
                    throw new IllegalStateException("Should never get there!");
                }
                CategoryDeclaration decl = (CategoryDeclaration)ApplicationContext.get().getRegisteredDeclaration(CategoryDeclaration.class, type2.getTypeNameId());
                return GraphQLInputObjectType.newInputObject().name(type2.getTypeName() + "Input").fields(this._buildInputFields(decl, registry2)).build();
            }

            private List<GraphQLInputObjectField> _buildInputFields(CategoryDeclaration decl, GraphQLCodeRegistry.Builder registry2) {
                return decl.getAllAttributes(ApplicationContext.get()).stream().map(a -> this._buildInputField((Identifier)a, registry2)).filter(Objects::nonNull).collect(Collectors.toList());
            }

            private GraphQLInputObjectField _buildInputField(Identifier attr, GraphQLCodeRegistry.Builder registry2) {
                AttributeDeclaration decl = (AttributeDeclaration)ApplicationContext.get().getRegisteredDeclaration(AttributeDeclaration.class, attr);
                return GraphQLInputObjectField.newInputObjectField().name(attr.toString()).type(GraphQLType.buildInputType(decl.getType(), registry2)).build();
            }
        };
    }
}

