/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.source;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.jaas.spi.UserInfo;
import prompto.config.auth.source.IStoredAuthenticationSourceConfiguration;
import prompto.security.auth.JettyLoginModuleBase;
import prompto.security.auth.StoredUserInfoCache;

public class StoredPasswordDigestAuthenticationSource
extends JettyLoginModuleBase {
    StoredUserInfoCache cache;

    public StoredPasswordDigestAuthenticationSource() {
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.cache = StoredUserInfoCache.initialize((IStoredAuthenticationSourceConfiguration)options.get("config"));
    }

    public StoredPasswordDigestAuthenticationSource(IStoredAuthenticationSourceConfiguration config) {
        this.cache = new StoredUserInfoCache(config);
    }

    public StoredPasswordDigestAuthenticationSource(StoredUserInfoCache cache) {
        this.cache = cache;
    }

    public UserInfo getUserInfo(String username) throws Exception {
        return this.cache.getUserInfo(username);
    }

    @Override
    public boolean hasLogin(String login) {
        try {
            return this.cache.hasLogin(login);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public boolean checkLogin(String login, String password) {
        try {
            return this.cache.checkLogin(login, password);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void createLogin(String login, String password) {
        try {
            this.cache.createLogin(login, password);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void updateLogin(String login, String password) {
        try {
            this.cache.updateLogin(login, password);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void finalize() {
        try {
            this.cache.close();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

