/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.error.PromptoError;
import prompto.expression.FetchManyExpression;
import prompto.expression.IExpression;
import prompto.expression.IFetchExpression;
import prompto.literal.IntegerLiteral;
import prompto.parser.ECleverParser;
import prompto.server.CleverServlet;
import prompto.server.JsonRecordsWriter;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.utils.Logger;

public class DataServlet
extends CleverServlet {
    static Logger logger = new Logger();
    static Map<String, IStore> stores;

    public static void setStores(Map<String, IStore> stores) {
        DataServlet.stores = stores;
    }

    public static Map<String, IStore> getStores() {
        return stores;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        String path = req.getPathInfo();
        if (path != null) {
            switch (path) {
                case "/fetch": {
                    this.doFetch(req, resp);
                    break;
                }
                default: {
                    resp.sendError(404);
                }
            }
        }
    }

    protected void doFetch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block23: {
            IFetchExpression fetch;
            String format;
            String last;
            String first;
            IStore dataStore;
            ServletOutputStream stream;
            block21: {
                block22: {
                    ECleverParser parser;
                    String query;
                    block19: {
                        block20: {
                            block17: {
                                block18: {
                                    String store;
                                    block15: {
                                        block16: {
                                            stream = resp.getOutputStream();
                                            store = req.getParameter("store");
                                            if (store != null && !store.trim().isEmpty()) break block15;
                                            this.writeJsonResponseError("No store specified!", (OutputStream)stream);
                                            if (stream == null) break block16;
                                            stream.close();
                                        }
                                        return;
                                    }
                                    dataStore = stores.get(store);
                                    if (dataStore != null) break block17;
                                    this.writeJsonResponseError("Invalid store: " + store, (OutputStream)stream);
                                    if (stream == null) break block18;
                                    stream.close();
                                }
                                return;
                            }
                            query = req.getParameter("query");
                            if (query != null && !query.trim().isEmpty()) break block19;
                            this.writeJsonResponseError("Empty query!", (OutputStream)stream);
                            if (stream == null) break block20;
                            stream.close();
                        }
                        return;
                    }
                    first = req.getParameter("first");
                    last = req.getParameter("last");
                    format = req.getParameter("format");
                    if (format == null) {
                        format = "list";
                    }
                    if ((fetch = (parser = new ECleverParser(query)).parse_fetch_expression()) != null) break block21;
                    this.writeJsonResponseError("Invalid query: " + query, (OutputStream)stream);
                    if (stream == null) break block22;
                    stream.close();
                }
                return;
            }
            try {
                try {
                    DataServlet.adjustQueryRange(fetch, first, last);
                    logger.info(() -> "Running query: " + fetch.toString());
                    if ("list".equals(format.toLowerCase())) {
                        resp.setContentType("application/json");
                        Object fetched = fetch.fetchRaw(dataStore);
                        JsonRecordsWriter writer = new JsonRecordsWriter((OutputStream)stream, arg_0 -> ((IStore)dataStore).getAttributeInfo(arg_0), dataStore, false);
                        writer.writeRecords(fetched);
                        break block23;
                    }
                    this.writeJsonResponseError("Invalid query!", (OutputStream)stream);
                }
                catch (PromptoError e) {
                    this.writeJsonResponseError("Invalid query!", (OutputStream)stream);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    resp.sendError(500);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
    }

    private static void adjustQueryRange(IFetchExpression fetch, String first, String last) {
        if (fetch instanceof FetchManyExpression) {
            FetchManyExpression many = (FetchManyExpression)fetch;
            if (many.getFirst() == null && first != null) {
                many.setFirst((IExpression)new IntegerLiteral(first));
            }
            if (many.getLast() == null && last != null) {
                many.setLast((IExpression)new IntegerLiteral(last));
            }
        }
    }

    static String readCategory(IStored value) {
        List categories = (List)value.getData("category");
        if (categories == null || categories.size() < 1) {
            return "<undefined>";
        }
        return (String)categories.get(categories.size() - 1);
    }
}

