/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import prompto.utils.Logger;

public class LoggingCrossOriginFilter
extends CrossOriginFilter {
    static Logger logger = new Logger();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug(() -> "CrossOriginFilter: " + request.toString());
            this.logRequestHeaders((HttpServletRequest)request, "*");
        }
        super.doFilter(request, response, chain);
        if (logger.isDebugEnabled()) {
            this.logResponseHeaders((HttpServletResponse)response, "Access-Control-Allow-Origin");
        }
    }

    private void logRequestHeaders(HttpServletRequest request, String ... headers) {
        if (headers.length == 1 && headers[0].equals("*")) {
            Enumeration names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                logger.debug(() -> "Request " + name + ": " + request.getHeader(name));
            }
        } else {
            for (String header : headers) {
                logger.debug(() -> "Request " + header + ": " + request.getHeader(header));
            }
        }
    }

    private void logResponseHeaders(HttpServletResponse response, String ... headers) {
        if (headers.length == 1 && headers[0].equals("*")) {
            Collection names = response.getHeaderNames();
            for (String name : names) {
                logger.debug(() -> "Request " + name + ": " + response.getHeader(name));
            }
        } else {
            for (String header : headers) {
                logger.debug(() -> "Response " + header + ": " + response.getHeader(header));
            }
        }
    }
}

