/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import prompto.compiler.PromptoClassLoader;
import prompto.debug.ProcessDebugger;
import prompto.debug.WorkerDebugger;
import prompto.error.ExecutionError;
import prompto.error.PromptoError;
import prompto.error.TerminatedError;
import prompto.expression.IExpression;
import prompto.expression.MethodSelector;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.remoting.RemoteArgumentList;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Executor;
import prompto.runtime.Interpreter;
import prompto.runtime.Standalone;
import prompto.server.ExecutionMode;
import prompto.statement.MethodCall;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.memory.MemStore;
import prompto.utils.Logger;
import prompto.value.BinaryValue;
import prompto.value.IValue;
import prompto.value.TextValue;

public class RequestRouter {
    static final Logger logger = new Logger();

    public void route(ExecutionMode mode, Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        boolean isTest = methodName.toString().startsWith("\"") && methodName.toString().endsWith("\"");
        switch (mode) {
            case INTERPRET: {
                if (isTest) {
                    this.interpretTest(methodName, response);
                    break;
                }
                this.interpretMethod(methodName, jsonParams, parts, main, response);
                break;
            }
            case EXECUTE: {
                if (isTest) {
                    this.executeTest(methodName, response);
                    break;
                }
                this.executeMethod(methodName, jsonParams, parts, main, response);
                break;
            }
            default: {
                throw new InvalidParameterException(mode.name());
            }
        }
    }

    private Context prepareContext(String name) {
        Context context = ApplicationContext.get().newLocalContext();
        ProcessDebugger processDebugger = ProcessDebugger.getInstance();
        if (processDebugger != null) {
            logger.info(() -> "Wiring debugger for incoming request");
            WorkerDebugger workerDebugger = Standalone.startWorkerDebugger((Thread)Thread.currentThread(), (Context)context);
            workerDebugger.stepInto();
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(Identifier testName, HttpServletResponse response) throws Exception {
        logger.debug(() -> "Executing test: " + testName.toString());
        PrintStream oldOut = System.out;
        IStore oldStore = DataStore.getInstance();
        DataStore.setInstance((IStore)new MemStore());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        Context context = this.prepareContext("Test: " + testName);
        try (PromptoClassLoader loader2 = Standalone.getClassLoader();){
            Executor.executeTest((PromptoClassLoader)loader2, (String)testName.toString());
            bytes.flush();
            String[] lines = new String(bytes.toByteArray()).split("\n");
            this.writeJsonResponse(lines, response);
        }
        catch (TerminatedError loader2) {
        }
        catch (PromptoError e) {
            this.writeJsonErrorResponse(context, e, response);
        }
        finally {
            context.notifyCompleted();
            DataStore.setInstance((IStore)oldStore);
            System.setOut(oldOut);
            logger.debug(() -> "Done executing test: " + testName.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interpretTest(Identifier testName, HttpServletResponse response) throws IOException {
        logger.debug(() -> "Interpreting test: " + testName.toString());
        PrintStream oldOut = System.out;
        IStore oldStore = DataStore.getInstance();
        DataStore.setInstance((IStore)new MemStore());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        Context context = this.prepareContext("Test: " + testName);
        try {
            Interpreter.interpretTest((Context)context, (Identifier)testName, (boolean)true);
            bytes.flush();
            String[] lines = new String(bytes.toByteArray()).split("\n");
            this.writeJsonResponse(lines, response);
        }
        catch (TerminatedError lines) {
        }
        catch (PromptoError e) {
            this.writeJsonErrorResponse(context, e, response);
        }
        finally {
            context.notifyCompleted();
            DataStore.setInstance((IStore)oldStore);
            System.setOut(oldOut);
            logger.debug(() -> "Done interpreting test: " + testName.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMethod(Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        logger.debug(() -> "Executing method: " + methodName);
        Context context = this.prepareContext("Method: " + methodName);
        try (PromptoClassLoader loader2 = Standalone.getClassLoader();){
            Object result;
            RemoteArgumentList params = RemoteArgumentList.read((Context)context, (String)jsonParams, parts);
            Class[] argTypes = params.toJavaTypes(context, (ClassLoader)loader2);
            Object[] args = params.toJavaValues(context);
            if (params.isEmpty() && main) {
                argTypes = new Class[]{PromptoDict.class};
                args = new Object[]{null};
            }
            TextValue text = new TextValue((result = Executor.executeGlobalMethod((PromptoClassLoader)loader2, (Identifier)methodName, (Class[])argTypes, (Object[])args)) == null ? "success!" : result.toString());
            this.writeJsonResponse(context, (IValue)text, response);
        }
        catch (TerminatedError loader2) {
        }
        catch (PromptoError e) {
            this.writeJsonErrorResponse(context, e, response);
        }
        finally {
            context.notifyCompleted();
            logger.debug(() -> "Done executing method: " + methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretMethod(Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        logger.debug(() -> "Interpreting method: " + methodName);
        Context context = this.prepareContext("Method: " + methodName);
        try {
            RemoteArgumentList params = RemoteArgumentList.read((Context)context, (String)jsonParams, parts);
            ArgumentList arguments = params.toArguments(context);
            IValue value = this.interpretMethod(context, methodName, arguments, main);
            if (value == null) {
                value = new TextValue("Success!");
            }
            if (value instanceof BinaryValue) {
                this.writeBinaryResponse((BinaryValue)value, response);
            } else {
                this.writeJsonResponse(context, value, response);
            }
        }
        catch (TerminatedError params) {
        }
        catch (PromptoError e) {
            this.writeJsonErrorResponse(context, e, response);
        }
        finally {
            context.notifyCompleted();
            logger.debug(() -> "Done interpreting method: " + methodName);
        }
    }

    private IValue interpretMethod(Context context, Identifier methodName, ArgumentList arguments, boolean eligibleForMain) {
        if (arguments.isEmpty() && eligibleForMain) {
            return Interpreter.interpretMainNoArgs((Context)context, (Identifier)methodName);
        }
        MethodCall methodCall = new MethodCall(new MethodSelector(methodName), arguments);
        return methodCall.interpret(context);
    }

    private void writeBinaryResponse(BinaryValue value, HttpServletResponse response) throws IOException {
        try (ServletOutputStream output = response.getOutputStream();){
            response.setContentType(value.getMimeType());
            response.setStatus(200);
            output.write(value.getBytes());
        }
    }

    private void writeJsonResponse(Context context, IValue value, HttpServletResponse response) throws IOException, PromptoError {
        try (ServletOutputStream output = response.getOutputStream();){
            response.setContentType("text/json");
            response.setStatus(200);
            try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);){
                generator.writeStartObject();
                generator.writeNullField("error");
                if (value == null) {
                    generator.writeNullField("data");
                } else {
                    generator.writeFieldName("data");
                    value.toJsonStream(context, generator, true, null);
                }
                generator.writeEndObject();
                generator.flush();
            }
        }
    }

    private void writeJsonResponse(String[] lines, HttpServletResponse response) throws IOException, PromptoError {
        try (ServletOutputStream output = response.getOutputStream();){
            response.setContentType("text/json");
            response.setStatus(200);
            try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);){
                generator.writeStartObject();
                generator.writeNullField("error");
                generator.writeArrayFieldStart("data");
                for (String line : lines) {
                    generator.writeString(line);
                }
                generator.writeEndArray();
                generator.writeEndObject();
                generator.flush();
            }
        }
    }

    private void writeJsonErrorResponse(Context context, PromptoError error, HttpServletResponse response) throws IOException {
        try (ServletOutputStream output = response.getOutputStream();){
            response.setContentType("text/json");
            response.setStatus(200);
            try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);){
                generator.writeStringField("error", this.getErrorMessage(context, error));
                generator.writeNullField("data");
                generator.writeEndObject();
                generator.flush();
            }
        }
    }

    private String getErrorMessage(Context context, PromptoError error) {
        String message = error.getMessage();
        if (message != null) {
            return message;
        }
        if (error instanceof ExecutionError) {
            try {
                IExpression expression = ((ExecutionError)error).getExpression(context);
                IValue value = expression.interpret(context);
                if (value != null) {
                    return value.toString();
                }
            }
            catch (PromptoError promptoError) {
                // empty catch block
            }
        }
        return "Internal error, please contact Prompto support";
    }
}

