/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoDbId;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.server.CleverServlet;
import prompto.server.JsonRecordsWriter;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.IAuditMetadata;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.type.BinaryType;
import prompto.utils.Logger;

public class StoreServlet
extends CleverServlet {
    static Logger logger = new Logger();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setMultipartConfig(new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        this.doStuff(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        this.doStuff(req, resp);
    }

    protected void doStuff(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path != null) {
            switch (path) {
                case "/fetchOne": {
                    this.fetchOne(req, resp);
                    break;
                }
                case "/fetchMany": {
                    this.fetchMany(req, resp);
                    break;
                }
                case "/deleteAndStore": {
                    this.deleteAndStore(req, resp);
                    break;
                }
                default: {
                    resp.sendError(404);
                }
            }
        }
    }

    protected void deleteAndStore(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block11: {
            try (ServletOutputStream output = resp.getOutputStream();){
                try {
                    String contentType = req.getContentType();
                    if (contentType.startsWith("application/json")) {
                        this.deleteAndStoreJson(req, resp, (OutputStream)output);
                        break block11;
                    }
                    if (contentType.startsWith("application/x-www-form-urlencoded")) {
                        this.deleteAndStoreUrlEncoded(req, resp, (OutputStream)output);
                        break block11;
                    }
                    if (contentType.startsWith("multipart/form-data")) {
                        this.deleteAndStoreMultipart(req, resp, (OutputStream)output);
                        break block11;
                    }
                    resp.sendError(415);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    resp.setStatus(500);
                    this.writeJSONError(t.getMessage(), output);
                }
            }
        }
    }

    private void deleteAndStoreJson(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        Map<Object, Object> updatedDbIds = new HashMap();
        JsonNode json = this.readJsonStream(req);
        JsonNode toDelete = null;
        JsonNode toStore = null;
        if (json.has("toDelete")) {
            toDelete = json.get("toDelete");
        }
        if (json.has("toStore")) {
            toStore = json.get("toStore");
        }
        if (toDelete != null || toStore != null) {
            updatedDbIds = this.deleteAndStoreJson(toDelete, toStore, null, json.get("withMeta"));
        }
        this.writeJSONResult(updatedDbIds, output);
    }

    private Map<Long, PromptoDbId> deleteAndStoreJson(JsonNode toDelete, JsonNode toStore, Map<String, byte[]> parts, JsonNode withMeta) {
        Collection<PromptoDbId> deletables = this.collectDeletables(toDelete);
        HashMap<Long, PromptoDbId> updatedDbIds = new HashMap<Long, PromptoDbId>();
        List<IStorable> storables = this.collectStorables(toStore, parts, updatedDbIds);
        IAuditMetadata metadata = this.collectMetadata(withMeta, parts);
        DataStore.getInstance().deleteAndStore(deletables, storables, metadata);
        return updatedDbIds;
    }

    private Collection<PromptoDbId> collectDeletables(JsonNode toDelete) {
        if (toDelete == null) {
            return null;
        }
        return this.jsonToDbIdsCollection(toDelete);
    }

    private Collection<PromptoDbId> jsonToDbIdsCollection(JsonNode node) {
        Object converted = this.convertJsonToDbIds(node);
        if (converted == null) {
            return Collections.emptyList();
        }
        if (converted instanceof Collection) {
            return (Collection)converted;
        }
        if (converted instanceof PromptoDbId) {
            return Collections.singletonList((PromptoDbId)converted);
        }
        throw new UnsupportedOperationException(converted.getClass().getName());
    }

    private Object convertJsonToDbIds(JsonNode node) {
        if (node.isNumber()) {
            return this.convertJsonToDbId(node.asLong());
        }
        if (node.isTextual()) {
            return this.convertJsonToDbId(node.asText());
        }
        if (node.isArray()) {
            return StreamSupport.stream(node.spliterator(), false).map(this::convertJsonToDbIds).collect(Collectors.toList());
        }
        logger.error(() -> "Could not convert: " + node.toString());
        return null;
    }

    private Object convertJsonToDbId(Object dbId) {
        return DataStore.getInstance().convertToDbId(dbId);
    }

    private List<IStorable> collectStorables(JsonNode toStore, Map<String, byte[]> parts, Map<Long, PromptoDbId> updatedDbIds) {
        if (toStore == null) {
            return null;
        }
        if (toStore.isArray()) {
            return StreamSupport.stream(toStore.spliterator(), false).map(node -> this.jsonToStorable((JsonNode)node, parts, updatedDbIds)).collect(Collectors.toList());
        }
        logger.error(() -> "Could not store: " + toStore.toString());
        return null;
    }

    private IStorable jsonToStorable(JsonNode record, Map<String, byte[]> parts, Map<Long, PromptoDbId> updatedDbIds) {
        if (this.isRecordUpdate(record)) {
            return this.populateExistingStorable(record, parts, updatedDbIds);
        }
        return this.populateNewStorable(record, parts, updatedDbIds);
    }

    private boolean isRecordUpdate(JsonNode record) {
        JsonNode dbIdField = record.get("dbId");
        return dbIdField != null && !dbIdField.has("tempDbId");
    }

    private IStorable populateExistingStorable(JsonNode record, Map<String, byte[]> parts, Map<Long, PromptoDbId> updatedDbIds) {
        Object rawDbId = this.readJsonValue(record.get("dbId"), parts, updatedDbIds);
        final PromptoDbId dbId = DataStore.getInstance().convertToDbId(rawDbId);
        IStorable.IDbIdFactory dbIdFactory = new IStorable.IDbIdFactory(){

            public void accept(PromptoDbId dbId2) {
                throw new IllegalStateException();
            }

            public PromptoDbId get() {
                return dbId;
            }

            public boolean isUpdate() {
                return true;
            }
        };
        List<String> categories = this.readJsonCategories(record);
        IStorable storable = DataStore.getInstance().newStorable(categories, dbIdFactory);
        Iterator fieldNames = record.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("dbId".equals(fieldName)) continue;
            Object value = this.readJsonValue(record.get(fieldName), parts, updatedDbIds);
            storable.setData(fieldName, value);
        }
        return storable;
    }

    private IStorable populateNewStorable(JsonNode record, Map<String, byte[]> parts, final Map<Long, PromptoDbId> updatedDbIds) {
        final Long tempDbId = record.get("dbId").get("tempDbId").asLong();
        final PromptoDbId dbId = DataStore.getInstance().convertToDbId(updatedDbIds.getOrDefault(tempDbId, null));
        IStorable.IDbIdFactory dbIdFactory = new IStorable.IDbIdFactory(){

            public void accept(PromptoDbId newDbId) {
                updatedDbIds.put(tempDbId, newDbId);
            }

            public PromptoDbId get() {
                return dbId;
            }

            public boolean isUpdate() {
                return false;
            }
        };
        List<String> categories = this.readJsonCategories(record);
        IStorable storable = DataStore.getInstance().newStorable(categories, dbIdFactory);
        Iterator fieldNames = record.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("dbId".equals(fieldName)) continue;
            Object value = this.readJsonValue(record.get(fieldName), parts, updatedDbIds);
            storable.setData(fieldName, value);
        }
        return storable;
    }

    private Object readJsonValue(JsonNode fieldValue, Map<String, byte[]> parts, Map<Long, PromptoDbId> updatedDbIds) {
        if (fieldValue.has("tempDbId")) {
            return updatedDbIds.computeIfAbsent(fieldValue.get("tempDbId").asLong(), k -> DataStore.getInstance().newDbId());
        }
        if (fieldValue.isDouble() || fieldValue.isFloat()) {
            return fieldValue.asDouble();
        }
        if (fieldValue.isLong() || fieldValue.isInt()) {
            return fieldValue.asLong();
        }
        if (fieldValue.isBoolean()) {
            return fieldValue.asBoolean();
        }
        if (fieldValue.isTextual()) {
            return fieldValue.asText();
        }
        if (fieldValue.isNull()) {
            return null;
        }
        if (fieldValue.isObject()) {
            if (fieldValue.has("name")) {
                return fieldValue.get("name").asText();
            }
            return this.readJsonValue(fieldValue.get("type").asText(), fieldValue.get("value"), parts, updatedDbIds);
        }
        if (fieldValue.isArray()) {
            return StreamSupport.stream(fieldValue.spliterator(), false).map(node -> this.readJsonValue((JsonNode)node, parts, updatedDbIds)).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException(fieldValue.getNodeType().name());
    }

    private Object readJsonValue(String type, JsonNode fieldValue, Map<String, byte[]> parts, Map<Long, PromptoDbId> updatedDbIds) {
        switch (type) {
            case "Uuid": {
                return UUID.fromString(fieldValue.asText());
            }
            case "Date": {
                return PromptoDate.parse((String)fieldValue.asText());
            }
            case "Time": {
                return PromptoTime.parse((String)fieldValue.asText());
            }
            case "DateTime": {
                return PromptoDateTime.parse((String)fieldValue.asText());
            }
            case "Version": {
                return PromptoVersion.parse((String)fieldValue.asText());
            }
            case "Blob": 
            case "Image": {
                return BinaryType.readJSONValue((JsonNode)fieldValue, parts);
            }
            case "DbId": 
            case "%dbRef%": {
                return DataStore.getInstance().convertToNativeDbId(this.readJsonValue(fieldValue, parts, updatedDbIds));
            }
        }
        throw new UnsupportedOperationException(type);
    }

    private List<String> readJsonCategories(JsonNode node) {
        return StreamSupport.stream(node.get("category").spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
    }

    private IAuditMetadata collectMetadata(JsonNode withMeta, Map<String, byte[]> parts) {
        if (withMeta != null) {
            if (withMeta.isObject()) {
                if (DataStore.getInstance().isAuditEnabled()) {
                    IAuditMetadata metadata = DataStore.getInstance().newAuditMetadata();
                    withMeta.fields().forEachRemaining(e -> this.collectMetadata(metadata, (Map.Entry<String, JsonNode>)e, parts));
                    return metadata;
                }
                logger.error(() -> "Could not store metadata because audit is disabled.");
            } else {
                logger.error(() -> "Could not convert: " + withMeta.toString());
            }
        }
        return null;
    }

    private void collectMetadata(IAuditMetadata metadata, Map.Entry<String, JsonNode> entry, Map<String, byte[]> parts) {
        metadata.put((Object)entry.getKey(), this.readJsonValue(entry.getValue(), parts, Collections.emptyMap()));
    }

    private void deleteAndStoreMultipart(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws ServletException, IOException {
        HashMap result = new HashMap();
        Map<String, byte[]> parts = this.readPartsAsBytes(req);
        JsonNode toDelete = null;
        JsonNode toStore = null;
        JsonNode withMeta = null;
        if (parts.containsKey("toDelete")) {
            toDelete = new ObjectMapper().readTree(parts.get("toDelete"));
        }
        if (parts.containsKey("toStore")) {
            toStore = new ObjectMapper().readTree(parts.get("toStore"));
        }
        if (toDelete != null || toStore != null) {
            if (parts.containsKey("withMeta")) {
                withMeta = new ObjectMapper().readTree(parts.get("withMeta"));
            }
            Map<Long, PromptoDbId> updatedDbIds = this.deleteAndStoreJson(toDelete, toStore, parts, withMeta);
            updatedDbIds.forEach((k, v) -> result.put(k, v.getValue()));
        }
        this.writeJSONResult(result, output);
    }

    private void deleteAndStoreUrlEncoded(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        resp.sendError(415);
    }

    protected void fetchMany(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block11: {
            try (ServletOutputStream output = resp.getOutputStream();){
                try {
                    String contentType = req.getContentType();
                    if (contentType.startsWith("application/json")) {
                        this.fetchManyJson(req, resp, (OutputStream)output);
                        break block11;
                    }
                    if (contentType.startsWith("application/x-www-form-urlencoded")) {
                        this.fetchManyUrlEncoded(req, resp, (OutputStream)output);
                        break block11;
                    }
                    if (contentType.startsWith("multipart/form-data")) {
                        this.fetchManyMultipart(req, resp, (OutputStream)output);
                        break block11;
                    }
                    resp.sendError(415);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    resp.setStatus(500);
                    this.writeJSONError(t.getMessage(), output);
                }
            }
        }
    }

    private void fetchManyMultipart(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws ServletException, IOException {
        resp.sendError(415);
    }

    private void fetchManyUrlEncoded(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        resp.sendError(415);
    }

    private void fetchManyJson(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        JsonNode json = this.readJsonStream(req);
        IQueryBuilder builder = DataStore.getInstance().newQueryBuilder();
        if (json.has("predicate") && !json.get("predicate").isNull()) {
            this.readPredicateJson(builder, json.get("predicate"));
        }
        if (json.has("first") && !json.get("first").isNull()) {
            builder = builder.first(Long.valueOf(json.get("first").asLong()));
        }
        if (json.has("last") && !json.get("last").isNull()) {
            builder = builder.last(Long.valueOf(json.get("last").asLong()));
        }
        if (json.has("projection") && json.get("projection").isArray()) {
            this.readProjectionJson(builder, json.get("projection"));
        }
        if (json.has("orderBys") && !json.get("orderBys").isNull()) {
            this.readOrderBysJson(builder, json.get("orderBys"));
        }
        resp.setContentType("application/json");
        IStoredIterable fetched = DataStore.getInstance().fetchMany(builder.build());
        JsonRecordsWriter writer = new JsonRecordsWriter(output, this::fetchAttributeInfo, DataStore.getInstance(), true);
        writer.writeRecords(fetched);
    }

    protected void fetchOne(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block11: {
            try (ServletOutputStream output = resp.getOutputStream();){
                try {
                    String contentType = req.getContentType();
                    if (contentType.startsWith("application/json")) {
                        this.fetchOneJson(req, resp, (OutputStream)output);
                        break block11;
                    }
                    if (contentType.startsWith("application/x-www-form-urlencoded")) {
                        this.fetchOneUrlEncoded(req, resp, (OutputStream)output);
                        break block11;
                    }
                    if (contentType.startsWith("multipart/form-data")) {
                        this.fetchOneMultipart(req, resp, (OutputStream)output);
                        break block11;
                    }
                    resp.sendError(415);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    resp.setStatus(500);
                    this.writeJSONError(t.getMessage(), output);
                }
            }
        }
    }

    private void fetchOneMultipart(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        resp.sendError(415);
    }

    private void fetchOneUrlEncoded(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        resp.sendError(415);
    }

    private void fetchOneJson(HttpServletRequest req, HttpServletResponse resp, OutputStream output) throws IOException {
        JsonNode json = this.readJsonStream(req);
        IQueryBuilder builder = DataStore.getInstance().newQueryBuilder();
        if (json.has("predicate") && !json.get("predicate").isNull()) {
            this.readPredicateJson(builder, json.get("predicate"));
        }
        if (json.has("projection") && json.get("projection").isArray()) {
            this.readProjectionJson(builder, json.get("projection"));
        }
        resp.setContentType("application/json");
        IStored fetched = DataStore.getInstance().fetchOne(builder.build());
        JsonRecordsWriter writer = new JsonRecordsWriter(output, this::fetchAttributeInfo, DataStore.getInstance(), true);
        writer.writeRecord(fetched);
    }

    private void readProjectionJson(IQueryBuilder builder, JsonNode jsonNode) {
        List projection = StreamSupport.stream(jsonNode.spliterator(), false).map(node -> node.asText()).collect(Collectors.toList());
        builder.project(projection);
    }

    private void readOrderBysJson(IQueryBuilder builder, JsonNode orderBys) {
        for (JsonNode orderBy : orderBys) {
            AttributeInfo info = DataStore.getInstance().getAttributeInfo(orderBy.get("info").get("name").asText());
            builder.orderBy(info, orderBy.get("descending").asBoolean());
        }
    }

    private void readPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        String type;
        switch (type = jsonNode.get("type").asText()) {
            case "MatchPredicate": {
                this.readMatchPredicateJson(builder, jsonNode);
                break;
            }
            case "AndPredicate": {
                this.readAndPredicateJson(builder, jsonNode);
                break;
            }
            case "OrPredicate": {
                this.readOrPredicateJson(builder, jsonNode);
                break;
            }
            case "NotPredicate": {
                this.readNotPredicateJson(builder, jsonNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException(type);
            }
        }
    }

    private void readMatchPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        String name = jsonNode.get("info").get("name").asText();
        AttributeInfo info = this.fetchAttributeInfo(name);
        IQueryBuilder.MatchOp matchOp = IQueryBuilder.MatchOp.valueOf((String)jsonNode.get("matchOp").get("name").asText());
        Object value = this.readJsonValue(jsonNode.get("value"), null, new HashMap<Long, PromptoDbId>());
        if ("dbId".equals(name) && value != null) {
            value = value instanceof Collection ? ((Collection)value).stream().map(arg_0 -> ((IStore)DataStore.getInstance()).convertToNativeDbId(arg_0)).collect(Collectors.toList()) : DataStore.getInstance().convertToNativeDbId(value);
        }
        builder.verify(info, matchOp, value);
    }

    private AttributeInfo fetchAttributeInfo(String name) {
        return DataStore.getInstance().getAttributeInfo(name);
    }

    private void readAndPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        this.readPredicateJson(builder, jsonNode.get("left"));
        this.readPredicateJson(builder, jsonNode.get("right"));
        builder.and();
    }

    private void readOrPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        this.readPredicateJson(builder, jsonNode.get("left"));
        this.readPredicateJson(builder, jsonNode.get("right"));
        builder.or();
    }

    private void readNotPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        this.readPredicateJson(builder, jsonNode.get("predicate"));
        builder.not();
    }

    private JsonNode readJsonStream(HttpServletRequest req) throws IOException {
        try (ServletInputStream input = req.getInputStream();){
            JsonNode jsonNode = new ObjectMapper().readTree((InputStream)input);
            return jsonNode;
        }
    }
}

