/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.util.function.Supplier;
import prompto.config.IKeyStoreConfiguration;
import prompto.config.auth.IAuthenticationConfiguration;

public interface IHttpConfiguration {
    public String getProtocol();

    public int getPort();

    public String getWelcomePage();

    public String getSiteMap();

    public Integer getRedirectFrom();

    public String getAllowedOrigins();

    public IKeyStoreConfiguration getKeyStoreConfiguration();

    public IKeyStoreConfiguration getTrustStoreConfiguration();

    public IAuthenticationConfiguration getAuthenticationConfiguration();

    public boolean getAllowsXAuthorization();

    public boolean getSendsXAuthorization();

    public String getPublicAddress();

    public IHttpConfiguration withProtocol(String var1);

    public IHttpConfiguration withPort(int var1);

    public IHttpConfiguration withWelcomePage(String var1);

    public IHttpConfiguration withSiteMap(String var1);

    public IHttpConfiguration withSendsXAuthorization(boolean var1);

    public IHttpConfiguration withKeyStoreConfiguration(IKeyStoreConfiguration var1);

    public IHttpConfiguration withTrustStoreConfiguration(IKeyStoreConfiguration var1);

    public IHttpConfiguration withAuthenticationConfiguration(IAuthenticationConfiguration var1);

    public IHttpConfiguration withPublicAddress(String var1);

    public YamlMapping toYaml() throws YamlException;

    public static class Inline
    implements IHttpConfiguration {
        Supplier<String> protocol = () -> null;
        Supplier<Integer> port = () -> 0;
        Supplier<String> welcomePage = () -> null;
        Supplier<String> siteMap = () -> null;
        Supplier<Integer> redirectFrom = () -> null;
        Supplier<String> allowedOrigins = () -> null;
        Supplier<IKeyStoreConfiguration> keyStoreConfiguration = () -> null;
        Supplier<IKeyStoreConfiguration> trustStoreConfiguration = () -> null;
        Supplier<IAuthenticationConfiguration> authenticationConfiguration = () -> null;
        Supplier<Boolean> allowsXAuthorization = () -> false;
        Supplier<Boolean> sendsXAuthorization = () -> false;
        Supplier<String> publicAddress = () -> null;

        @Override
        public String getProtocol() {
            return this.protocol.get();
        }

        @Override
        public int getPort() {
            return this.port.get();
        }

        @Override
        public String getWelcomePage() {
            return this.welcomePage.get();
        }

        @Override
        public String getSiteMap() {
            return this.siteMap.get();
        }

        @Override
        public Integer getRedirectFrom() {
            return this.redirectFrom.get();
        }

        @Override
        public String getAllowedOrigins() {
            return this.allowedOrigins.get();
        }

        @Override
        public IKeyStoreConfiguration getKeyStoreConfiguration() {
            return this.keyStoreConfiguration.get();
        }

        @Override
        public IKeyStoreConfiguration getTrustStoreConfiguration() {
            return this.trustStoreConfiguration.get();
        }

        @Override
        public IAuthenticationConfiguration getAuthenticationConfiguration() {
            return this.authenticationConfiguration.get();
        }

        @Override
        public boolean getAllowsXAuthorization() {
            return this.allowsXAuthorization.get();
        }

        @Override
        public boolean getSendsXAuthorization() {
            return this.sendsXAuthorization.get();
        }

        @Override
        public String getPublicAddress() {
            return this.publicAddress.get();
        }

        @Override
        public IHttpConfiguration withProtocol(String proto) {
            this.protocol = () -> proto;
            return this;
        }

        @Override
        public IHttpConfiguration withPort(int num) {
            this.port = () -> num;
            return this;
        }

        @Override
        public IHttpConfiguration withWelcomePage(String welcomePage) {
            this.welcomePage = () -> welcomePage;
            return this;
        }

        @Override
        public IHttpConfiguration withSiteMap(String siteMap) {
            this.siteMap = () -> siteMap;
            return this;
        }

        @Override
        public IHttpConfiguration withSendsXAuthorization(boolean set) {
            this.sendsXAuthorization = () -> set;
            return this;
        }

        @Override
        public IHttpConfiguration withKeyStoreConfiguration(IKeyStoreConfiguration config) {
            this.keyStoreConfiguration = () -> config;
            return this;
        }

        @Override
        public IHttpConfiguration withTrustStoreConfiguration(IKeyStoreConfiguration config) {
            this.trustStoreConfiguration = () -> config;
            return this;
        }

        @Override
        public IHttpConfiguration withAuthenticationConfiguration(IAuthenticationConfiguration config) {
            this.authenticationConfiguration = () -> config;
            return this;
        }

        @Override
        public IHttpConfiguration withPublicAddress(String name) {
            this.publicAddress = () -> name;
            return this;
        }

        @Override
        public YamlMapping toYaml() throws YamlException {
            return null;
        }
    }
}

