/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.auth.source;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import prompto.config.IConfigurationReader;
import prompto.config.IStoreConfiguration;
import prompto.config.YamlConfigurationReader;
import prompto.config.auth.source.AuthenticationSourceConfiguration;
import prompto.config.auth.source.IStoredAuthenticationSourceConfiguration;
import prompto.security.auth.source.StoredPasswordDigestAuthenticationSourceFactory;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.store.IStored;

public class StoredAuthenticationSourceConfiguration
extends AuthenticationSourceConfiguration
implements IStoredAuthenticationSourceConfiguration {
    public StoredAuthenticationSourceConfiguration(IConfigurationReader reader) {
        super(reader);
    }

    @Override
    public IStoreConfiguration getStoreConfiguration() {
        if (this.reader.hasKey("storeName")) {
            return this.fetchStoreConfigurationFromStoredRecord(DataStore.getInstance());
        }
        if (this.reader.hasKey("store")) {
            return this.reader.readStoreConfiguration("store");
        }
        return null;
    }

    private IStoreConfiguration fetchStoreConfigurationFromStoredRecord(IStore store) {
        String storeName = this.reader.getString("storeName");
        IStored stored = this.fetchStoreRecord(store, storeName);
        String dbName = (String)stored.getData("dbName");
        String serverName = (String)stored.getData("dbServer");
        stored = this.fetchServerRecord(store, serverName);
        String yaml = (String)stored.getData("config");
        return new YamlConfigurationReader((InputStream)new ByteArrayInputStream(yaml.getBytes())).readStoreConfiguration().withDbName(dbName);
    }

    private IStored fetchServerRecord(IStore store, String serverName) {
        IQuery query = store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.CONTAINS, (Object)"DataServer").verify(AttributeInfo.NAME, IQueryBuilder.MatchOp.EQUALS, (Object)serverName).and().build();
        return store.fetchOne(query);
    }

    private IStored fetchStoreRecord(IStore store, String storeName) {
        IQuery query = store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.CONTAINS, (Object)"DataStore").verify(AttributeInfo.NAME, IQueryBuilder.MatchOp.EQUALS, (Object)storeName).and().build();
        return store.fetchOne(query);
    }

    @Override
    public YamlMapping toYaml() throws YamlException {
        IStoreConfiguration store = this.getStoreConfiguration();
        if (store != null) {
            YamlMapping yaml = new YamlMapping();
            yaml.setEntry("factory", StoredPasswordDigestAuthenticationSourceFactory.class.getName());
            yaml.setEntry("store", (YamlElement)store.toYaml());
            return yaml;
        }
        return null;
    }
}

