/*
 * Decompiled with CFR 0.152.
 */
package prompto.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import prompto.code.ICodeStore;
import prompto.graphql.GraphQLSchemaBuilder;
import prompto.graphql.GraphQLType;
import prompto.server.CleverServlet;
import prompto.utils.Instance;
import prompto.utils.JsonUtils;
import prompto.utils.StreamUtils;

public class GraphQLServlet
extends CleverServlet {
    static Instance<GraphQLServlet> instance = new Instance();
    GraphQL graphQL;

    public static boolean isEnabled() {
        Iterable decls = ICodeStore.getInstance().fetchDeclarationsWithAnnotations(new HashSet<String>(Arrays.asList("@GraphQLQuery", "@GraphQLMutation")));
        return decls.iterator().hasNext();
    }

    public static void reset() {
        if (instance.get() != null) {
            ((GraphQLServlet)((Object)GraphQLServlet.instance.get())).graphQL = null;
        }
        GraphQLType.TYPE_BY_NAME_MAP.clear();
    }

    public GraphQLServlet() {
        instance.set((Object)this);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.unsafeDoPost(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            response.setStatus(500);
        }
    }

    void unsafeDoPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (ServletInputStream input = request.getInputStream();){
            GraphQLRequest gql = this.readRequest(request, (InputStream)input);
            ExecutionResult result = this.executeRequest(gql);
            String json = JsonUtils.objectToJson((Object)result.toSpecification());
            try (PrintWriter writer = response.getWriter();){
                response.setContentType("application/json");
                writer.print(json);
            }
        }
    }

    private ExecutionResult executeRequest(GraphQLRequest request) {
        ExecutionInput input = ExecutionInput.newExecutionInput().query(request.query).variables(request.variables).build();
        GraphQL gql = this.getGraphQL();
        return gql.execute(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphQL getGraphQL() {
        if (this.graphQL == null) {
            GraphQLServlet graphQLServlet = this;
            synchronized (graphQLServlet) {
                GraphQLSchema schema = new GraphQLSchemaBuilder().build();
                this.graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).build();
            }
        }
        return this.graphQL;
    }

    private GraphQLRequest readRequest(HttpServletRequest request, InputStream input) throws IOException, ServletException {
        String contentType;
        String[] contentParts = request.getContentType().split(";");
        switch (contentType = contentParts[0]) {
            case "application/graphql": {
                return this.readRequestFromGraphQL(input);
            }
            case "application/json": {
                return this.readRequestFromJSON(input);
            }
            case "multipart/form-data": {
                return this.readRequestFromMultipart(request);
            }
        }
        throw new UnsupportedOperationException("Unsupported content type: " + contentType);
    }

    private GraphQLRequest readRequestFromMultipart(HttpServletRequest request) throws IOException, ServletException {
        Part part = request.getPart("operations");
        if (part == null) {
            throw new UnsupportedOperationException("Missing 'operations' part");
        }
        GraphQLRequest gql = this.readRequestFromPart(part);
        Map<String, Part> uploads = this.readRequestUploads(request);
        this.linkUploadVariables(gql.variables, uploads);
        return gql;
    }

    private void linkUploadVariables(Map<String, Object> variables, Map<String, Part> uploads) {
        uploads.forEach((path, part) -> this.linkUploadVariable(variables, (String)path, (Part)part));
    }

    private void linkUploadVariable(Map<String, Object> variables, String path, Part part) {
        String[] parts = path.split("\\.");
        if (parts.length != 1) {
            throw new UnsupportedOperationException("yet");
        }
        variables.put(parts[0], part);
    }

    private Map<String, Part> readRequestUploads(HttpServletRequest request) throws IOException, ServletException {
        Part part = request.getPart("map");
        if (part == null) {
            throw new UnsupportedOperationException("Missing 'map' part");
        }
        return this.readRequestUploads(request, part);
    }

    private Map<String, Part> readRequestUploads(HttpServletRequest request, Part part) throws IOException, ServletException {
        try (InputStream input = part.getInputStream();){
            ObjectNode json = (ObjectNode)JsonUtils.parseInput((InputStream)input);
            Map map = JsonUtils.toMap((ObjectNode)json);
            HashMap uploads = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                Part file = request.getPart((String)entry.getKey());
                ((List)entry.getValue()).forEach(s -> uploads.put(s, file));
            }
            HashMap hashMap = uploads;
            return hashMap;
        }
    }

    private GraphQLRequest readRequestFromPart(Part part) throws IOException {
        try (InputStream input = part.getInputStream();){
            String data = StreamUtils.readString((InputStream)input);
            GraphQLRequest graphQLRequest = this.readRequestFromJSON(data);
            return graphQLRequest;
        }
    }

    private GraphQLRequest readRequestFromJSON(InputStream input) throws IOException {
        String query = StreamUtils.readString((InputStream)input);
        return this.readRequestFromJSON(query);
    }

    private GraphQLRequest readRequestFromJSON(String query) throws IOException {
        JsonNode node = JsonUtils.parseString((String)query);
        return this.readRequestFromJSON(node);
    }

    private GraphQLRequest readRequestFromJSON(JsonNode json) {
        if (json.has("query") && json.get("query").isTextual()) {
            GraphQLRequest request = new GraphQLRequest();
            request.query = json.get("query").asText();
            if (json.has("variables") && json.get("variables").isObject()) {
                ObjectNode vars = (ObjectNode)json.get("variables");
                request.variables = JsonUtils.toMap((ObjectNode)vars);
            } else {
                request.variables = Collections.emptyMap();
            }
            return request;
        }
        throw new UnsupportedOperationException("Missing 'query' field: " + json.toString());
    }

    private GraphQLRequest readRequestFromGraphQL(InputStream input) throws IOException {
        GraphQLRequest request = new GraphQLRequest();
        request.query = StreamUtils.readString((InputStream)input);
        request.variables = Collections.emptyMap();
        return request;
    }

    static class GraphQLRequest {
        String query;
        Map<String, Object> variables;

        GraphQLRequest() {
        }
    }
}

