/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.util.security.Credential;
import prompto.config.IStoreConfiguration;
import prompto.config.auth.source.IStoredAuthenticationSourceConfiguration;
import prompto.intrinsic.PromptoDbId;
import prompto.security.auth.method.DigestMethod;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.store.IStored;
import prompto.utils.Logger;

public class StoredUserInfoCache {
    static Logger logger = new Logger();
    static StoredUserInfoCache instance = null;
    static Timer timer = new Timer();
    static long KEEP_ALIVE_DELAY = 30000L;
    static final AttributeInfo LOGIN = new AttributeInfo("login", Family.TEXT, false, Arrays.asList("key"));
    static final AttributeInfo SALT = new AttributeInfo("salt", Family.TEXT, false, null);
    static final AttributeInfo METHOD = new AttributeInfo("method", Family.TEXT, false, null);
    static final AttributeInfo DIGEST = new AttributeInfo("digest", Family.TEXT, false, null);
    static final AttributeInfo QUESTIONS = new AttributeInfo("questions", Family.CATEGORY, true, null);
    static final AttributeInfo QUESTION = new AttributeInfo("question", Family.TEXT, false, null);
    static final AttributeInfo ANSWER = new AttributeInfo("answer", Family.TEXT, false, null);
    Map<String, StoredPasswordDigestCredential> cache = new ConcurrentHashMap<String, StoredPasswordDigestCredential>(new HashMap());
    IStore store;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StoredUserInfoCache initialize(IStoredAuthenticationSourceConfiguration config) {
        if (instance != null) return instance;
        Class<StoredUserInfoCache> clazz = StoredUserInfoCache.class;
        synchronized (StoredUserInfoCache.class) {
            if (instance != null) return instance;
            instance = new StoredUserInfoCache(config);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    instance.evictOldEntriesFromCache();
                }
            };
            timer.scheduleAtFixedRate(task, 30000L, 30000L);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public StoredUserInfoCache(IStoredAuthenticationSourceConfiguration config) {
        IStoreConfiguration storeConfig = config.getStoreConfiguration();
        try {
            this.store = IStoreFactory.newStoreFromConfig((IStoreConfiguration)storeConfig);
            this.store.createOrUpdateAttributes(Arrays.asList(LOGIN, SALT, METHOD, DIGEST, QUESTIONS, QUESTION, ANSWER));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public StoredUserInfoCache(IStore store) {
        this.store = store;
        store.createOrUpdateAttributes(Arrays.asList(LOGIN, SALT, METHOD, DIGEST, QUESTIONS, QUESTION, ANSWER));
    }

    void evictOldEntriesFromCache() {
        long now = System.currentTimeMillis();
        this.cache.values().stream().filter(c -> now - c.lastChecked > KEEP_ALIVE_DELAY).collect(Collectors.toList()).forEach(c -> this.cache.remove(c.userName));
    }

    public UserInfo getUserInfo(String username) {
        StoredPasswordDigestCredential credential = this.cache.computeIfAbsent(username, u -> new StoredPasswordDigestCredential((String)u));
        return new UserInfo(username, (Credential)credential, Collections.singletonList("*"));
    }

    public boolean hasLogin(String login) {
        IQueryBuilder query = this.store.newQueryBuilder();
        query.verify(LOGIN, IQueryBuilder.MatchOp.EQUALS, (Object)login);
        IStored authRecord = this.store.fetchOne(query.build());
        return authRecord != null;
    }

    public boolean checkLogin(String login, String password) throws NoSuchAlgorithmException {
        StoredPasswordDigestCredential credential = new StoredPasswordDigestCredential(login);
        return credential.check(password);
    }

    public void createLogin(String login, String password) throws NoSuchAlgorithmException {
        StoredUserInfoCache.createLogin(this.store, login, password);
    }

    public void updateLogin(String login, String password) throws NoSuchAlgorithmException {
        IQueryBuilder query = this.store.newQueryBuilder();
        query.verify(LOGIN, IQueryBuilder.MatchOp.EQUALS, (Object)login);
        final IStored stored = this.store.fetchOne(query.build());
        if (stored == null) {
            return;
        }
        String salt = DigestMethod.newSalt();
        IStorable storable = this.store.newStorable(Arrays.asList("User"), new IStorable.IDbIdFactory(){

            public void accept(PromptoDbId t) {
            }

            public PromptoDbId get() {
                return stored.getDbId();
            }

            public boolean isUpdate() {
                return true;
            }
        });
        storable.setData("login", (Object)login);
        storable.setData("salt", (Object)salt);
        storable.setData("method", (Object)"PBKDF2");
        String digest = DigestMethod.forName("PBKDF2").digest(password, salt);
        storable.setData("digest", (Object)digest);
        this.store.store(storable);
        this.cache.remove(login);
    }

    public void close() throws IOException {
        this.store.close();
    }

    public static void createLogin(IStore store, String login, String password) throws NoSuchAlgorithmException {
        String salt = DigestMethod.newSalt();
        IStorable storable = store.newStorable(Arrays.asList("User"), null);
        storable.setData("login", (Object)login);
        storable.setData("salt", (Object)salt);
        storable.setData("method", (Object)"PBKDF2");
        String digest = DigestMethod.forName("PBKDF2").digest(password, salt);
        storable.setData("digest", (Object)digest);
        storable.setDbId(store.newDbId());
        store.store(storable);
    }

    class StoredPasswordDigestCredential
    extends Credential {
        String userName;
        long lastChecked;
        int hashed;

        public StoredPasswordDigestCredential(String userName) {
            this.userName = userName;
            this.lastChecked = 0L;
            this.hashed = 0;
        }

        public boolean check(Object credentials) {
            if (this.wasCheckedRecently(credentials)) {
                return true;
            }
            if (!this.checkNow(credentials)) {
                return false;
            }
            this.lastChecked = System.currentTimeMillis();
            this.hashed = String.valueOf(credentials).hashCode();
            return true;
        }

        private boolean checkNow(Object credentials) {
            logger.info(() -> "Authenticating user: " + this.userName);
            if (this.isNullCredentials(credentials)) {
                return false;
            }
            IQueryBuilder query = StoredUserInfoCache.this.store.newQueryBuilder();
            query.verify(LOGIN, IQueryBuilder.MatchOp.EQUALS, (Object)this.userName);
            IStored authRecord = StoredUserInfoCache.this.store.fetchOne(query.build());
            if (authRecord == null) {
                logger.info(() -> "Unkown user: " + this.userName);
                return false;
            }
            DigestMethod method = DigestMethod.forName((String)authRecord.getData(METHOD.getName()));
            if (method == null) {
                return false;
            }
            Object storedDigest = authRecord.getData(DIGEST.getName());
            if (storedDigest == null) {
                return false;
            }
            Object storedSalt = authRecord.getData(SALT.getName());
            if (storedSalt == null) {
                return false;
            }
            String computedDigest = (String)method.apply(credentials.toString(), storedSalt.toString());
            boolean equal = Objects.equals(storedDigest, computedDigest);
            if (equal) {
                logger.info(() -> "Successfully authenticated user: " + this.userName);
            } else {
                logger.info(() -> "Invalid password for user: " + this.userName);
            }
            return equal;
        }

        private boolean wasCheckedRecently(Object credentials) {
            long delay = System.currentTimeMillis() - this.lastChecked;
            if (delay > KEEP_ALIVE_DELAY) {
                return false;
            }
            return this.hashed == String.valueOf(credentials).hashCode();
        }

        private boolean isNullCredentials(Object credentials) {
            return credentials == null || credentials instanceof String && credentials.toString().isEmpty();
        }
    }
}

