/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDbId;
import prompto.server.CleverServlet;
import prompto.store.DataStore;
import prompto.store.IStore;

public class BinaryServlet
extends CleverServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        try (ServletOutputStream stream = resp.getOutputStream();){
            String dbIdString = req.getParameter("dbId");
            String attr = req.getParameter("attribute");
            String table = req.getParameter("table");
            IStore store = DataStore.getInstance();
            PromptoDbId dbId = store.convertToDbId((Object)dbIdString);
            PromptoBinary binary = store.fetchBinary(table, dbId, attr);
            if (binary != null) {
                resp.setContentType(binary.getMimeType());
                stream.write(binary.getBytes());
            } else {
                resp.setStatus(404);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            resp.sendError(500);
        }
    }
}

