/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.graphql.GraphQLServlet;
import prompto.runtime.ApplicationContext;
import prompto.server.AppServer;
import prompto.server.CleverServlet;
import prompto.utils.Logger;

public class ControlServlet
extends CleverServlet {
    static final Logger logger = new Logger();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        try {
            resp.setContentType("text/plain");
            try (PrintWriter writer = resp.getWriter();){
                String verb = req.getPathInfo();
                logger.info(() -> "Executing control verb " + verb);
                switch (verb) {
                    case "/exit": {
                        this.exitServer(writer);
                        return;
                    }
                    case "/clear-context": {
                        this.clearContext(writer);
                        return;
                    }
                    case "/version": {
                        this.version(writer);
                        return;
                    }
                    default: {
                        logger.error(() -> "Invalid control verb: " + verb);
                        resp.sendError(404);
                        return;
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            resp.sendError(500);
        }
    }

    private void version(PrintWriter writer) {
        writer.write("1.0.0");
        writer.flush();
    }

    private void clearContext(PrintWriter writer) {
        ApplicationContext.reset();
        GraphQLServlet.reset();
    }

    private void exitServer(PrintWriter writer) {
        writer.write("Exit command received\n");
        logger.info(() -> "Trying to stop server...");
        writer.flush();
        writer.close();
        try {
            AppServer.stop();
            logger.info(() -> "Exit command succeeded\n");
        }
        catch (Exception e) {
            logger.error(() -> "Error while stopping server...", (Throwable)e);
        }
        Runtime.getRuntime().exit(0);
    }
}

