/*
 * Decompiled with CFR 0.152.
 */
package prompto.transpiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import prompto.code.ICodeStore;
import prompto.code.ModuleType;
import prompto.code.WebLibrary;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IWidgetDeclaration;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.store.DataStore;
import prompto.transpiler.IJSEngine;
import prompto.transpiler.Transpiler;
import prompto.utils.HtmlUtils;
import prompto.utils.Logger;
import prompto.utils.YamlUtils;

public class HtmlGenerator {
    static final Logger logger = new Logger();
    String userAgent;
    Map<String, Object> pageConfig;
    String htmlEngine = null;
    Set<String> headerEntries = new HashSet<String>();

    public HtmlGenerator(String userAgent, Map<String, Object> pageConfig) {
        this.userAgent = userAgent;
        this.pageConfig = pageConfig;
    }

    public void generate(Context context, File htmlFile) throws IOException {
        try (FileOutputStream output = new FileOutputStream(htmlFile);
             OutputStreamWriter writer = new OutputStreamWriter(output);
             PrintWriter printer = new PrintWriter(writer);){
            this.generate(context, printer);
        }
    }

    private void generate(Context context, PrintWriter printer) throws IOException {
        this.generateProlog(printer);
        Consumer<PrintWriter> bodyWriter = this.generateHeader(context, printer);
        bodyWriter.accept(printer);
        this.generateEpilog(printer);
    }

    private void generatePageRenderScript(PrintWriter printer, String widgetName) {
        printer.println("<script>");
        printer.println("function renderBody() {");
        printer.print("var pageWidget = React.createElement( ");
        printer.print(widgetName);
        printer.println(");");
        printer.print("ReactDOM.render(pageWidget, document.getElementById('body'));");
        printer.println("}");
        printer.println("</script>");
    }

    private void generateProlog(PrintWriter printer) {
        printer.println("<!DOCTYPE html>");
        printer.println("<html>");
    }

    private Consumer<PrintWriter> generateHeader(Context context, PrintWriter printer) throws IOException {
        printer.println("<head>");
        this.generateMetas(printer);
        this.generateTitle(printer);
        this.generateIcon(printer);
        this.generateName(printer);
        this.generatePromptoScripts(printer);
        try {
            this.generateLibraries(printer);
            Consumer<PrintWriter> bodyWriter = this.generatePageWidgetScript(context, printer);
            printer.println("</head>");
            return bodyWriter;
        }
        catch (Exception e) {
            return p -> this.generateException((PrintWriter)p, e);
        }
    }

    private void generateMetas(PrintWriter printer) {
        this.writeHeaderEntry(printer, "<meta charset='utf-8'>");
        Map<String, Object> config = this.getHeaderConfig();
        Object value = config.get("metas");
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(item -> {
                if (item instanceof String) {
                    this.writeHeaderEntry(printer, (String)item);
                } else {
                    logger.warn(() -> "Expected a String, got " + value.getClass().getName());
                }
            });
        } else {
            logger.warn(() -> "Expected a Collection, got " + value.getClass().getName());
        }
    }

    private void writeHeaderEntry(PrintWriter printer, String entry) {
        if (this.headerEntries.add(entry)) {
            printer.println(entry);
        } else {
            logger.warn(() -> "Duplicate header entry: " + entry);
        }
    }

    private Consumer<PrintWriter> generatePageWidgetScript(Context context, PrintWriter printer) {
        try {
            String widgetName = this.getWidgetName();
            this.generatePageWidgetScript(context, printer, widgetName);
            return this::generateBody;
        }
        catch (SyntaxError e) {
            logger.error(() -> "While generating page", (Throwable)e);
            return p -> this.generateSyntaxError((PrintWriter)p, e);
        }
        catch (Exception e) {
            return p -> this.generateException((PrintWriter)p, e);
        }
    }

    private void generateException(PrintWriter printer, Exception e) {
        printer.println("<body>");
        e.printStackTrace(printer);
        printer.println("</body>");
    }

    private void generateSyntaxError(PrintWriter printer, SyntaxError e) {
        printer.println("<body>");
        printer.println("Syntax error '" + HtmlUtils.encodeHtmlEntities((String)e.getMessage()) + "'");
        printer.println("</body>");
    }

    private String getWidgetName() {
        Map<String, Object> body = this.getBodyConfig();
        if (body == null) {
            throw new SyntaxError("Missing 'body' section in page descriptor");
        }
        Object value = body.get("widget");
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            throw new SyntaxError("Missing 'widget' entry in 'body' section of page descriptor");
        }
        throw new SyntaxError("Expected a String for 'widget', got " + value.getClass().getName());
    }

    private void generatePageWidgetScript(Context context, PrintWriter printer, String widgetName) {
        IWidgetDeclaration widget = this.fetchWidgetDeclaration(context, widgetName);
        if (widget == null) {
            throw new SyntaxError("No such widget '" + widgetName + "'");
        }
        this.generatePageWidgetScript(printer, widget);
        this.generatePageRenderScript(printer, widgetName);
    }

    private IWidgetDeclaration fetchWidgetDeclaration(Context context, String widgetName) {
        CategoryDeclaration decl = (CategoryDeclaration)context.getRegisteredDeclaration(CategoryDeclaration.class, new Identifier(widgetName));
        if (decl != null && decl.isAWidget(context)) {
            return decl.asWidget();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePageWidgetScript(PrintWriter printer, IWidgetDeclaration declaration) {
        IJSEngine engine = IJSEngine.forUserAgent((String)this.userAgent);
        Context context = ApplicationContext.get().newLocalContext();
        Transpiler transpiler = new Transpiler(engine, context);
        declaration.declare(transpiler);
        if (transpiler.requires("DataStore")) {
            transpiler.require("Remote");
            transpiler.require("RemoteRunner");
            transpiler.require("RemoteStore");
            if (DataStore.getInstance().getNativeDbIdClass() == UUID.class) {
                transpiler.require("UUID");
            }
        }
        printer.println("<script id='transpiled'>");
        try {
            transpiler.print(printer);
        }
        finally {
            printer.println("</script>");
        }
    }

    private void generatePromptoScripts(PrintWriter printer) {
        this.writeHeaderEntry(printer, "<script src='https://cdnjs.cloudflare.com/ajax/libs/axios/0.17.1/axios.js'></script>");
        this.writeHeaderEntry(printer, "<script src='/js/lib/require.js'></script>");
        this.writeHeaderEntry(printer, "<script src='/js/lib/mousetrap.js'></script>");
    }

    private void generateLibraries(PrintWriter printer) throws Exception {
        Map<String, Object> config = this.getHeaderConfig();
        if (config == null) {
            return;
        }
        this.generateWebLibraries(printer, config);
        this.generateWidgetLibraries(printer, config);
        this.generateHtmlEngine(printer, config);
        this.generateUiFramework(printer, config);
        this.generateStyleSheets(printer, config);
        this.generateJavaScripts(printer, config);
    }

    private void generateWebLibraries(PrintWriter printer, Map<String, Object> config) throws Exception {
        Object value = config.get("webLibraries");
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                this.generateWebLibrary(printer, item);
            }
        } else {
            logger.warn(() -> "Expected a Collection, got " + value.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateWebLibrary(PrintWriter printer, Object entry) throws Exception {
        if (entry instanceof String) {
            this.generateWebLibrary(printer, (String)entry, PromptoVersion.LATEST);
            return;
        }
        if (!(entry instanceof Map)) throw new SyntaxError("Could not understand webLibraries entry: " + entry.toString());
        Object name = ((Map)entry).get("name");
        if (!(name instanceof String)) throw new SyntaxError("Missing 'name' in webLibraries entry: " + entry.toString());
        Object value = ((Map)entry).get("version");
        if (!(value instanceof String)) throw new SyntaxError("Missing 'version' in webLibraries entry: " + entry.toString());
        try {
            PromptoVersion version = PromptoVersion.parse((String)((String)value));
            this.generateWebLibrary(printer, (String)name, version);
            return;
        }
        catch (InvalidParameterException e) {
            throw new SyntaxError("Invalid 'version' in webLibraries entry: " + entry.toString());
        }
    }

    private void generateWebLibrary(PrintWriter printer, String name, PromptoVersion version) throws Exception {
        WebLibrary webLibrary = (WebLibrary)ICodeStore.getInstance().fetchVersionedModule(ModuleType.WEBLIBRARY, name, version);
        if (webLibrary == null) {
            throw new SyntaxError("Could not find webLibrary: " + name + ", version: " + version.toString());
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("htmlEngine", webLibrary.getHtmlEngine());
        config.put("javaScripts", webLibrary.getJavaScripts());
        config.put("styleSheets", webLibrary.getStyleSheets());
        this.generateHtmlEngine(printer, config);
        this.generateStyleSheets(printer, config);
        this.generateJavaScripts(printer, config);
    }

    private void generateStyleSheets(PrintWriter printer, Map<String, Object> config) {
        Object value = config.get("styleSheets");
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(item -> {
                if (item instanceof String) {
                    if (!((String)item).startsWith("http") && !((String)item).startsWith("/")) {
                        item = "/" + (String)item;
                    }
                    String styleSheet = "<link href='" + (String)item + "' rel='stylesheet'/>";
                    this.writeHeaderEntry(printer, styleSheet);
                } else {
                    logger.warn(() -> "Expected a String, got " + value.getClass().getName());
                }
            });
        } else {
            logger.warn(() -> "Expected a Collection, got " + value.getClass().getName());
        }
    }

    private void generateJavaScripts(PrintWriter printer, Map<String, Object> config) {
        Object value = config.get("javaScripts");
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(item -> {
                if (item instanceof String) {
                    if (!((String)item).startsWith("http") && !((String)item).startsWith("/")) {
                        item = "/" + (String)item;
                    }
                    String javaScript = "<script" + (((String)item).startsWith("http") ? " crossorigin " : "") + " src='" + (String)item + "'></script>";
                    this.writeHeaderEntry(printer, javaScript);
                } else {
                    logger.warn(() -> "Expected a String, got " + value.getClass().getName());
                }
            });
        } else {
            logger.warn(() -> "Expected a Collection, got " + value.getClass().getName());
        }
    }

    private void generateUiFramework(PrintWriter printer, Map<String, Object> config) throws IOException {
        Object value = config.get("uiFramework");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            config = YamlUtils.readResource((String)("uiFrameworks/" + value + ".yaml"));
            this.generateStyleSheets(printer, config);
            this.generateJavaScripts(printer, config);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateHtmlEngine(PrintWriter printer, Map<String, Object> config) throws Exception {
        Object value = config.get("htmlEngine");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            if (value.equals(this.htmlEngine)) {
                return;
            }
            if (this.htmlEngine != null) {
                throw new SyntaxError("HTML engine: " + value + " conflicts with: " + this.htmlEngine);
            }
            this.htmlEngine = (String)value;
            config = YamlUtils.readResource((String)("htmlEngines/" + value + ".yaml"));
            this.generateStyleSheets(printer, config);
            this.generateJavaScripts(printer, config);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateWidgetLibraries(PrintWriter printer, Map<String, Object> config) throws Exception {
        Object values = config.get("widgetLibraries");
        if (values == null) {
            return;
        }
        if (values instanceof Collection) {
            for (Object value : (Collection)values) {
                this.generateWidgetLibrary(value, printer, config);
            }
        } else {
            logger.warn(() -> "Expected a List, got " + values.getClass().getName());
        }
    }

    private void generateWidgetLibrary(Object value, PrintWriter printer, Map<String, Object> config) throws Exception {
        if (value instanceof String) {
            config = YamlUtils.readResource((String)("widgetLibraries/" + value + ".yaml"));
            this.generateHtmlEngine(printer, config);
            this.generateUiFramework(printer, config);
            this.generateStyleSheets(printer, config);
            this.generateJavaScripts(printer, config);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateIcon(PrintWriter printer) {
        Map<String, Object> header = this.getHeaderConfig();
        if (header == null) {
            return;
        }
        Object value = header.get("icon");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String icon = "<link href='" + value + "' rel='icon' type='image/ico'/>";
            this.writeHeaderEntry(printer, icon);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateTitle(PrintWriter printer) {
        Map<String, Object> header = this.getHeaderConfig();
        if (header == null) {
            return;
        }
        Object value = header.get("title");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String title = "<title>" + value + "</title>";
            this.writeHeaderEntry(printer, title);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateName(PrintWriter printer) {
        Map<String, Object> header = this.getHeaderConfig();
        if (header == null) {
            return;
        }
        Object value = header.get("name");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String name = "<script>\twindow.name = '" + value + "';\n</script>";
            this.writeHeaderEntry(printer, name);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private Map<String, Object> getHeaderConfig() {
        return this.getConfig(this.pageConfig, "header");
    }

    private Map<String, Object> getBodyConfig() {
        return this.getConfig(this.pageConfig, "body");
    }

    private Map<String, Object> getConfig(Map<String, Object> source, String key) {
        Object value = source.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        logger.warn(() -> "Expected a Map<String, Object>, got " + value.getClass().getName());
        return null;
    }

    private void generateBody(PrintWriter printer) {
        printer.println("<body onLoad='renderBody()'>");
        printer.println("<div id='body'></div>");
        printer.println("<div id='modal'></div>");
        printer.println("<div id='context'></div>");
        printer.println("</body>");
    }

    private void generateEpilog(PrintWriter printer) {
        printer.println("</html>");
    }
}

