/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import prompto.config.CmdLineConfigurationReader;
import prompto.config.IConfigurationReader;
import prompto.config.IStoreConfiguration;
import prompto.config.StandaloneConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.memstore.MemStoreFactory;
import prompto.utils.CmdLineParser;

public class TestCmdLineConfigurationReader {
    @Test
    public void testComplexCmdLine() {
        String[] args = new String[]{"-codeStore-factory", MemStoreFactory.class.getName(), "-codeStore-host", "localhost", "-codeStore-port", "27017", "-codeStore-dbName", "TOOLS", "-dataStore-factory", MemStoreFactory.class.getName(), "-dataStore-host", "localhost", "-dataStore-port", "27017", "-dataStore-dbName", "APPS", "-resourceURLs", "awsClient.pec", "-applicationName", "dev-center", "-applicationVersion", "1.2.31.7", "-mainMethod", "myMethod"};
        Map argsMap = CmdLineParser.read((String[])args);
        CmdLineConfigurationReader reader = new CmdLineConfigurationReader(argsMap);
        StandaloneConfiguration config = new StandaloneConfiguration((IConfigurationReader)reader, argsMap);
        Assert.assertEquals((Object)"dev-center", (Object)config.getApplicationName());
        Assert.assertEquals((Object)"myMethod", (Object)config.getMainMethod());
        Assert.assertEquals((Object)PromptoVersion.parse((String)"1.2.31.7"), (Object)config.getApplicationVersion());
        URL url = Thread.currentThread().getContextClassLoader().getResource("awsClient.pec");
        Assert.assertEquals(Collections.singletonList(url), Arrays.asList(config.getResourceURLs()));
        IStoreConfiguration store = config.getCodeStoreConfiguration();
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)MemStoreFactory.class.getName(), (Object)store.getFactory());
        Assert.assertEquals((Object)"localhost", (Object)store.getHost());
        Assert.assertEquals((long)27017L, (long)store.getPort().intValue());
        Assert.assertEquals((Object)"TOOLS", (Object)store.getDbName());
        store = config.getDataStoreConfiguration();
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)MemStoreFactory.class.getName(), (Object)store.getFactory());
        Assert.assertEquals((Object)"localhost", (Object)store.getHost());
        Assert.assertEquals((long)27017L, (long)store.getPort().intValue());
        Assert.assertEquals((Object)"APPS", (Object)store.getDbName());
    }
}

