/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.util.Map;
import java.util.function.Supplier;
import prompto.config.IConfigurationReader;
import prompto.config.IStandaloneConfiguration;
import prompto.config.RuntimeConfiguration;

public class StandaloneConfiguration
extends RuntimeConfiguration
implements IStandaloneConfiguration {
    Supplier<String> mainMethod = () -> null;
    Supplier<String> testMethod = () -> null;

    public StandaloneConfiguration(IConfigurationReader reader, Map<String, String> arguments) {
        super(reader, arguments);
        this.mainMethod = () -> reader.getStringOrDefault("mainMethod", "main");
        this.testMethod = () -> reader.getString("testMethod");
    }

    @Override
    public String getMainMethod() {
        return this.mainMethod.get();
    }

    @Override
    public String getTestMethod() {
        return this.testMethod.get();
    }

    @Override
    public IStandaloneConfiguration withMainMethod(String method) {
        this.mainMethod = () -> method;
        return this;
    }

    @Override
    public IStandaloneConfiguration withTestMethod(String method) {
        this.testMethod = () -> method;
        return this;
    }

    public YamlMapping toYaml() throws YamlException {
        YamlMapping yaml = super.toYaml();
        String main = this.mainMethod.get();
        if (main != null) {
            yaml.setEntry("mainMethod", main);
        }
        return yaml;
    }
}

