/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.config.DebugConfiguration;
import prompto.config.IConfigurationReader;
import prompto.config.IDebugConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Mode;

public class RuntimeConfiguration
extends IRuntimeConfiguration.Inline {
    IConfigurationReader reader;

    protected RuntimeConfiguration(IConfigurationReader reader, Map<String, String> arguments) {
        this.reader = reader;
        this.applicationName = () -> reader.getString("applicationName");
        this.applicationVersion = () -> this.readApplicationVersion();
        this.codeStoreConfiguration = () -> reader.readStoreConfiguration("codeStore");
        this.dataStoreConfiguration = () -> reader.readStoreConfiguration("dataStore");
        this.arguments = () -> arguments;
        this.addOnURLs = () -> this.readURLs("addOnURLs");
        this.resourceURLs = () -> this.readURLs("resourceURLs");
        this.debugConfiguration = () -> this.readDebugConfiguration();
        this.runtimeMode = () -> Mode.valueOf((String)reader.getStringOrDefault("runtimeMode", Mode.PRODUCTION.name()));
        this.loadRuntime = () -> reader.getBooleanOrDefault("loadRuntime", true);
    }

    private IDebugConfiguration readDebugConfiguration() {
        IConfigurationReader child = this.reader.getObject("debugger");
        return child == null ? null : new DebugConfiguration(child);
    }

    private PromptoVersion readApplicationVersion() {
        String version = this.reader.getString("applicationVersion");
        return version == null ? PromptoVersion.LATEST : PromptoVersion.parse((String)version);
    }

    private URL[] readURLs(String key) {
        Collection list = this.reader.getArray(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        List<URL> urls = list.stream().map(Object::toString).map(RuntimeConfiguration::convertToURL).collect(Collectors.toList());
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL convertToURL(String resourceName) {
        try {
            if (resourceName.startsWith("\"")) {
                resourceName = resourceName.substring(1);
            }
            if (resourceName.endsWith("\"")) {
                resourceName = resourceName.substring(0, resourceName.length() - 1);
            }
            if (resourceName.startsWith("file:") || resourceName.startsWith("jar:")) {
                return new URL(resourceName);
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            if (url != null) {
                return url;
            }
            File file = new File(resourceName);
            if (!file.exists()) {
                throw new FileNotFoundException(resourceName);
            }
            return file.toURI().toURL();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

