/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import prompto.debug.ClientStack;
import prompto.debug.IDebugRequest;
import prompto.debug.IDebugResponse;
import prompto.debug.IDebugger;
import prompto.debug.IStack;
import prompto.debug.IStackFrame;
import prompto.debug.IVariable;
import prompto.debug.IWorker;
import prompto.debug.LeanStack;
import prompto.debug.Status;
import prompto.debug.UnreachableException;
import prompto.parser.ISection;

public abstract class DebugRequestClient
implements IDebugger {
    String remoteHost;
    int remotePort;
    boolean connected = false;

    public void setRemote(String host, int port) {
        this.remoteHost = host;
        this.remotePort = port;
        this.connected = true;
    }

    public void setConnected(boolean set) {
        this.connected = set;
    }

    protected IDebugResponse send(IDebugRequest request) {
        return this.sendRequest(request, null);
    }

    protected abstract boolean isRemoteAlive();

    protected abstract IDebugResponse sendRequest(IDebugRequest var1, Consumer<Exception> var2);

    public Collection<? extends IWorker> getWorkers() {
        return Collections.emptyList();
    }

    public Status getWorkerStatus(IWorker worker) {
        if (!this.isRemoteAlive()) {
            return Status.TERMINATED;
        }
        return this.fetchWorkerStatus(worker);
    }

    private Status fetchWorkerStatus(IWorker worker) {
        if (!this.connected) {
            return Status.UNREACHABLE;
        }
        IDebugRequest.GetWorkerStatusRequest request = new IDebugRequest.GetWorkerStatusRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetStatusResponse) {
            return ((IDebugResponse.GetStatusResponse)response).getStatus();
        }
        return Status.UNREACHABLE;
    }

    public IStack<?> getStack(IWorker worker) {
        IDebugRequest.GetStackRequest request = new IDebugRequest.GetStackRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetStackResponse) {
            LeanStack stack = ((IDebugResponse.GetStackResponse)response).getStack();
            return new ClientStack((IDebugger)this, worker, stack);
        }
        throw new UnreachableException();
    }

    public Collection<? extends IVariable> getVariables(IWorker worker, IStackFrame frame) {
        IDebugRequest.GetVariablesRequest request = new IDebugRequest.GetVariablesRequest(worker, frame);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetVariablesResponse) {
            return ((IDebugResponse.GetVariablesResponse)response).getVariables();
        }
        throw new UnreachableException();
    }

    public IVariable getVariable(IWorker worker, IStackFrame frame, String name) {
        IDebugRequest.GetVariableRequest request = new IDebugRequest.GetVariableRequest(worker, frame, name);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetVariableResponse) {
            return ((IDebugResponse.GetVariableResponse)response).getVariable();
        }
        throw new UnreachableException();
    }

    public int getLineInFile(IWorker worker) {
        IDebugRequest.GetLineRequest request = new IDebugRequest.GetLineRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetLineResponse) {
            return ((IDebugResponse.GetLineResponse)response).getLineInFile();
        }
        throw new UnreachableException();
    }

    public int getLineInMethod(IWorker worker) {
        IDebugRequest.GetLineRequest request = new IDebugRequest.GetLineRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetLineResponse) {
            return ((IDebugResponse.GetLineResponse)response).getLineInMethod();
        }
        throw new UnreachableException();
    }

    public boolean isStepping(IWorker worker) {
        if (!this.connected) {
            return false;
        }
        IDebugRequest.IsSteppingRequest request = new IDebugRequest.IsSteppingRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.IsSteppingResponse) {
            return ((IDebugResponse.IsSteppingResponse)response).isStepping();
        }
        throw new UnreachableException();
    }

    public boolean isSuspended(IWorker worker) {
        if (!this.connected || this.isTerminated()) {
            return false;
        }
        return this.fetchWorkerStatus(worker) == Status.SUSPENDED;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean canResume(IWorker worker) {
        return !this.isTerminated() && this.isSuspended(worker);
    }

    public boolean canSuspend(IWorker worker) {
        return !this.isTerminated() && !this.isSuspended(worker);
    }

    public boolean canStepInto(IWorker worker) {
        return this.isSuspended(worker);
    }

    public boolean canStepOver(IWorker worker) {
        return this.isSuspended(worker);
    }

    public boolean canStepOut(IWorker worker) {
        return this.isSuspended(worker);
    }

    public void suspend(IWorker worker) {
        IDebugRequest.SuspendRequest request = new IDebugRequest.SuspendRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void resume(IWorker worker) {
        IDebugRequest.ResumeRequest request = new IDebugRequest.ResumeRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void terminate(IWorker worker) {
        IDebugRequest.TerminateRequest request = new IDebugRequest.TerminateRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void stepInto(IWorker worker) {
        IDebugRequest.StepIntoRequest request = new IDebugRequest.StepIntoRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void stepOut(IWorker worker) {
        IDebugRequest.StepOutRequest request = new IDebugRequest.StepOutRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void stepOver(IWorker worker) {
        IDebugRequest.StepOverRequest request = new IDebugRequest.StepOverRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void installBreakpoint(ISection worker) {
        IDebugRequest.InstallBreakpointRequest request = new IDebugRequest.InstallBreakpointRequest(worker);
        this.send((IDebugRequest)request);
    }
}

