/*
 * Decompiled with CFR 0.152.
 */
package prompto.cloud;

import java.net.URL;
import java.util.Collection;
import prompto.cloud.AwsHelper;
import prompto.utils.Logger;

public enum Cloud {
    AWS(new AwsHelper());

    static Logger logger;
    Helper helper;

    private Cloud(Helper helper) {
        this.helper = helper;
    }

    public boolean checkHost() {
        return this.helper.checkHost();
    }

    public Collection<URL> getJarURsL() {
        return this.helper.getJarURLs();
    }

    public boolean isInClassPath() {
        return this.helper.isInClassPath();
    }

    public static Cloud current() {
        logger.info(() -> "Checking current cloud...");
        for (Cloud cloud : Cloud.values()) {
            if (!cloud.checkHost()) continue;
            logger.info(() -> "Running on " + cloud.name() + " cloud.");
            return cloud;
        }
        logger.info(() -> "Not running on cloud.");
        return null;
    }

    static {
        logger = new Logger();
    }

    static interface Helper {
        public boolean checkHost();

        public boolean isInClassPath();

        public Collection<URL> getJarURLs();
    }
}

