/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import prompto.config.IRuntimeConfiguration;
import prompto.config.TempDirectories;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.Standalone;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.memory.MemStore;
import prompto.utils.Instance;

public class TestCodeStoreUpgrade {
    @Test
    public void upgradesDerivedFrom() throws Exception {
        final Instance dbId = new Instance();
        MemStore store = new MemStore();
        IStorable storable = store.newStorable(Arrays.asList("Declaration", "CategoryDeclaration", "ConcreteCategoryDeclaration"), new IStorable.IDbIdFactory(){

            public void accept(Object id) {
                dbId.set(id);
            }

            public Object get() {
                return null;
            }

            public boolean isUpdate() {
                return false;
            }
        });
        storable.setData("name", (Object)"Child");
        storable.setData("dialect", (Object)"O");
        storable.setData("body", (Object)"category Child extends Parent, Uncle;");
        store.store(storable);
        TempDirectories.create();
        Collection libs = Libraries.getPromptoLibraries(Libraries.class);
        IRuntimeConfiguration config = new IRuntimeConfiguration.Inline().withApplicationName("test").withApplicationVersion(PromptoVersion.LATEST).withRuntimeLibs(() -> libs);
        Standalone.bootstrapCodeStore((IStore)store, (IRuntimeConfiguration)config);
        IStored stored = store.fetchUnique(dbId.get());
        Assert.assertEquals(Arrays.asList("Parent", "Uncle"), (Object)stored.getData("derivedFrom"));
    }
}

