/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import prompto.debug.ProcessStatus;
import prompto.debug.Serializer;
import prompto.debug.ack.Acknowledged;
import prompto.debug.ack.IAcknowledgement;
import prompto.debug.request.GetProcessStatusDebugRequest;
import prompto.debug.request.GetWorkerStatusDebugRequest;
import prompto.debug.request.IDebugRequest;
import prompto.debug.request.InstallBreakpointDebugRequest;
import prompto.debug.response.GetProcessStatusDebugResponse;
import prompto.debug.response.IDebugResponse;
import prompto.parser.Dialect;
import prompto.parser.ISection;
import prompto.parser.Location;
import prompto.parser.Section;

public class TestDebugMessage {
    @Test
    public void testJsonNonEmpty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        NonEmptyClass o = new NonEmptyClass();
        o.field = "test";
        JsonNode json = mapper.valueToTree((Object)o);
        o = (NonEmptyClass)mapper.treeToValue((TreeNode)json, NonEmptyClass.class);
    }

    @Test
    public void testJsonEmpty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        EmptyClass o = new EmptyClass();
        JsonNode json = mapper.valueToTree((Object)o);
        o = (EmptyClass)mapper.treeToValue((TreeNode)json, EmptyClass.class);
    }

    @Test
    public void testJsonProcessStatusRequest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        GetProcessStatusDebugRequest o = new GetProcessStatusDebugRequest();
        JsonNode json = mapper.valueToTree((Object)o);
        o = (GetProcessStatusDebugRequest)mapper.treeToValue((TreeNode)json, GetProcessStatusDebugRequest.class);
    }

    @Test
    public void testProcessStatusRequestMessage() throws Exception {
        GetProcessStatusDebugRequest value = new GetProcessStatusDebugRequest();
        String message = Serializer.writeMessage((Object)value);
        IDebugRequest request = Serializer.readDebugRequest((String)message);
        Assert.assertTrue((boolean)(request instanceof GetProcessStatusDebugRequest));
    }

    @Test
    public void testJsonThreadStatusRequest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        GetWorkerStatusDebugRequest o = new GetWorkerStatusDebugRequest();
        JsonNode json = mapper.valueToTree((Object)o);
        o = (GetWorkerStatusDebugRequest)mapper.treeToValue((TreeNode)json, GetWorkerStatusDebugRequest.class);
    }

    @Test
    public void testThreadStatusRequestMessage() throws Exception {
        GetWorkerStatusDebugRequest value = new GetWorkerStatusDebugRequest();
        String message = Serializer.writeMessage((Object)value);
        IDebugRequest request = Serializer.readDebugRequest((String)message);
        Assert.assertTrue((boolean)(request instanceof GetWorkerStatusDebugRequest));
    }

    @Test
    public void testBreakpointRequestMessage() throws Exception {
        InstallBreakpointDebugRequest value = new InstallBreakpointDebugRequest((ISection)new Section("n/a", new Location(12, 18, 22), new Location(12, 22, 14), Dialect.E, true));
        String message = Serializer.writeMessage((Object)value);
        IDebugRequest request = Serializer.readDebugRequest((String)message);
        Assert.assertTrue((boolean)(request instanceof InstallBreakpointDebugRequest));
    }

    @Test
    public void testStatusResponseMessage() throws Exception {
        GetProcessStatusDebugResponse value = new GetProcessStatusDebugResponse(ProcessStatus.PROCESS_STARTING);
        String message = Serializer.writeMessage((Object)value);
        IDebugResponse response = Serializer.readDebugResponse((String)message);
        Assert.assertTrue((boolean)(response instanceof GetProcessStatusDebugResponse));
        Assert.assertEquals((Object)ProcessStatus.PROCESS_STARTING, (Object)((GetProcessStatusDebugResponse)response).getProcessStatus());
    }

    @Test
    public void testAcknowledgementMessage() throws Exception {
        Acknowledged value = new Acknowledged();
        String message = Serializer.writeMessage((Object)value);
        IAcknowledgement response = Serializer.readAcknowledgement((String)message);
        Assert.assertTrue((boolean)(response instanceof Acknowledged));
    }

    @Test
    public void testOpenStream() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        Serializer.DebugRequestMessage message = new Serializer.DebugRequestMessage();
        message.value = new GetProcessStatusDebugRequest();
        message.type = ((IDebugRequest)message.value).getClass().getSimpleName();
        JsonNode json = mapper.valueToTree((Object)message);
        String s = json.toString();
        try (ByteArrayInputStream input = new ByteArrayInputStream(s.getBytes());){
            mapper.readTree((InputStream)input);
            int read = ((InputStream)input).read();
            Assert.assertEquals((long)-1L, (long)read);
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                mapper.writeValue((OutputStream)output, (Object)message);
                output.flush();
                ((OutputStream)output).write(33);
            }
        }
    }

    static class NonEmptyClass {
        String field;

        NonEmptyClass() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }
    }

    static class EmptyClass {
        EmptyClass() {
        }
    }
}

