/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import prompto.debug.IDebugger;
import prompto.debug.UnreachableException;
import prompto.debug.WorkerStatus;
import prompto.debug.request.GetLineDebugRequest;
import prompto.debug.request.GetVariableDebugRequest;
import prompto.debug.request.GetVariablesDebugRequest;
import prompto.debug.request.GetWorkerStackDebugRequest;
import prompto.debug.request.GetWorkerStatusDebugRequest;
import prompto.debug.request.IDebugRequest;
import prompto.debug.request.InstallBreakpointDebugRequest;
import prompto.debug.request.IsSteppingDebugRequest;
import prompto.debug.request.ResumeDebugRequest;
import prompto.debug.request.StepIntoDebugRequest;
import prompto.debug.request.StepOutDebugRequest;
import prompto.debug.request.StepOverDebugRequest;
import prompto.debug.request.SuspendDebugRequest;
import prompto.debug.request.TerminateDebugRequest;
import prompto.debug.response.GetLineDebugResponse;
import prompto.debug.response.GetVariableDebugResponse;
import prompto.debug.response.GetVariablesDebugResponse;
import prompto.debug.response.GetWorkerStackDebugResponse;
import prompto.debug.response.GetWorkerStatusDebugResponse;
import prompto.debug.response.IDebugResponse;
import prompto.debug.response.IsSteppingDebugResponse;
import prompto.debug.stack.ClientStack;
import prompto.debug.stack.IStack;
import prompto.debug.stack.IStackFrame;
import prompto.debug.stack.LeanStack;
import prompto.debug.variable.IVariable;
import prompto.debug.worker.IWorker;
import prompto.parser.ISection;

public abstract class DebugRequestClient
implements IDebugger {
    String remoteHost;
    int remotePort;
    boolean connected = false;

    public void setRemote(String host, int port) {
        this.remoteHost = host;
        this.remotePort = port;
        this.connected = true;
    }

    public void setConnected(boolean set) {
        this.connected = set;
    }

    protected IDebugResponse send(IDebugRequest request) {
        return this.sendRequest(request, null);
    }

    protected abstract boolean isRemoteAlive();

    protected abstract IDebugResponse sendRequest(IDebugRequest var1, Consumer<Exception> var2);

    public Collection<? extends IWorker> getWorkers() {
        return Collections.emptyList();
    }

    public WorkerStatus getWorkerStatus(IWorker worker) {
        if (!this.isRemoteAlive()) {
            return WorkerStatus.WORKER_COMPLETED;
        }
        return this.fetchWorkerStatus(worker);
    }

    private WorkerStatus fetchWorkerStatus(IWorker worker) {
        if (!this.connected) {
            return WorkerStatus.WORKER_UNREACHABLE;
        }
        GetWorkerStatusDebugRequest request = new GetWorkerStatusDebugRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof GetWorkerStatusDebugResponse) {
            return ((GetWorkerStatusDebugResponse)response).getWorkerStatus();
        }
        return WorkerStatus.WORKER_UNREACHABLE;
    }

    public IStack<?> getWorkerStack(IWorker worker) {
        GetWorkerStackDebugRequest request = new GetWorkerStackDebugRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof GetWorkerStackDebugResponse) {
            LeanStack stack = ((GetWorkerStackDebugResponse)response).getStack();
            return new ClientStack((IDebugger)this, worker, stack);
        }
        throw new UnreachableException();
    }

    public Collection<? extends IVariable> getVariables(IWorker worker, IStackFrame frame) {
        GetVariablesDebugRequest request = new GetVariablesDebugRequest(worker, frame);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof GetVariablesDebugResponse) {
            return ((GetVariablesDebugResponse)response).getVariables();
        }
        throw new UnreachableException();
    }

    public IVariable getVariable(IWorker worker, IStackFrame frame, String name) {
        GetVariableDebugRequest request = new GetVariableDebugRequest(worker, frame, name);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof GetVariableDebugResponse) {
            return ((GetVariableDebugResponse)response).getVariable();
        }
        throw new UnreachableException();
    }

    public int getLineInFile(IWorker worker) {
        GetLineDebugRequest request = new GetLineDebugRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof GetLineDebugResponse) {
            return ((GetLineDebugResponse)response).getLineInFile();
        }
        throw new UnreachableException();
    }

    public int getLineInMethod(IWorker worker) {
        GetLineDebugRequest request = new GetLineDebugRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof GetLineDebugResponse) {
            return ((GetLineDebugResponse)response).getLineInMethod();
        }
        throw new UnreachableException();
    }

    public boolean isStepping(IWorker worker) {
        if (!this.connected) {
            return false;
        }
        IsSteppingDebugRequest request = new IsSteppingDebugRequest(worker);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IsSteppingDebugResponse) {
            return ((IsSteppingDebugResponse)response).isStepping();
        }
        throw new UnreachableException();
    }

    public boolean isSuspended(IWorker worker) {
        if (!this.connected || this.isTerminated()) {
            return false;
        }
        return this.fetchWorkerStatus(worker) == WorkerStatus.WORKER_SUSPENDED;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean canResume(IWorker worker) {
        return !this.isTerminated() && this.isSuspended(worker);
    }

    public boolean canSuspend(IWorker worker) {
        return !this.isTerminated() && !this.isSuspended(worker);
    }

    public boolean canStepInto(IWorker worker) {
        return this.isSuspended(worker);
    }

    public boolean canStepOver(IWorker worker) {
        return this.isSuspended(worker);
    }

    public boolean canStepOut(IWorker worker) {
        return this.isSuspended(worker);
    }

    public void suspend(IWorker worker) {
        SuspendDebugRequest request = new SuspendDebugRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void resume(IWorker worker) {
        ResumeDebugRequest request = new ResumeDebugRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void terminate(IWorker worker) {
        TerminateDebugRequest request = new TerminateDebugRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void stepInto(IWorker worker) {
        StepIntoDebugRequest request = new StepIntoDebugRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void stepOut(IWorker worker) {
        StepOutDebugRequest request = new StepOutDebugRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void stepOver(IWorker worker) {
        StepOverDebugRequest request = new StepOverDebugRequest(worker);
        this.send((IDebugRequest)request);
    }

    public void installBreakpoint(ISection section) {
        InstallBreakpointDebugRequest request = new InstallBreakpointDebugRequest(section);
        this.send((IDebugRequest)request);
    }
}

