/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.debug.DebugRequestClient;
import prompto.debug.IDebugEventListener;
import prompto.debug.JavaDebugEventListener;
import prompto.debug.JavaDebugRequestClient;
import prompto.debug.OnlyRemoteThread;
import prompto.debug.ProcessDebugger;
import prompto.debug.ResumeReason;
import prompto.debug.SuspendReason;
import prompto.debug.TestDebuggerVariablesBase;
import prompto.debug.WorkerStatus;
import prompto.debug.event.ConnectedDebugEvent;
import prompto.debug.java.JavaDebugEventAdapterFactory;
import prompto.debug.java.JavaDebugRequestListenerFactory;
import prompto.debug.worker.IWorker;
import prompto.runtime.Standalone;
import prompto.runtime.utils.Out;
import prompto.store.NullStoreFactory;

public class TestRemoteThreadDebugger
extends TestDebuggerVariablesBase
implements IDebugEventListener {
    Thread thread;
    JavaDebugEventListener eventServer;
    String output = null;
    Object lock;

    @Before
    public void before() {
        ProcessDebugger.reset();
        this.output = null;
        Out.init();
    }

    @After
    public void after() {
        Out.restore();
    }

    protected String readOut() {
        if (this.output == null) {
            String[] lines = Out.read().split("\n");
            this.output = lines.length > 0 ? lines[lines.length - 1] : "";
        }
        return this.output;
    }

    protected void waitWorkerSuspendedOrTerminated() throws Exception {
        Thread.sleep(10L);
        WorkerStatus status = this.debugger.getWorkerStatus(this.getDebuggedThread());
        while (status != WorkerStatus.WORKER_SUSPENDED && status != WorkerStatus.WORKER_COMPLETED) {
            Thread.sleep(100L);
            status = this.debugger.getWorkerStatus(this.getDebuggedThread());
        }
    }

    protected IWorker getDebuggedThread() {
        return new OnlyRemoteThread();
    }

    protected void start() throws Exception {
        this.thread.start();
        this.debugger = new JavaDebugRequestClient.Thread(this.thread, this.eventServer);
        this.waitConnected();
    }

    protected void join() throws Exception {
        this.thread.join();
    }

    protected void setDebuggedResource(final String resourceName) throws Exception {
        this.eventServer = new JavaDebugEventListener(this);
        final int port = this.eventServer.startListening();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] args = new String[]{"-runtimeMode", "UNITTEST", "-debugger-eventAdapter-factory", JavaDebugEventAdapterFactory.class.getName(), "-debugger-eventAdapter-port", String.valueOf(port), "-debugger-requestListener-factory", JavaDebugRequestListenerFactory.class.getName(), "-codeStore-factory", NullStoreFactory.class.getName(), "-applicationName", "test", "-resourceURLs", TestRemoteThreadDebugger.this.getResourceAsURL(resourceName).toString()};
                    Standalone.main((String[])args);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        }, "Prompto main");
    }

    @Test
    public void testStackNoDebug() throws Exception {
        this.interpretResource("debug/stack.pec", false);
        Assert.assertEquals((Object)"test123-ok", (Object)this.readOut());
    }

    public URL tryGetCoreResource(String resourceName) throws Exception {
        File file = this.tryLocateCoreFile(resourceName);
        if (file != null) {
            return file.toURI().toURL();
        }
        return null;
    }

    public File tryLocateCoreFile(String resourceName) throws FileNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String dirPath = loader.getResource("").getFile();
        int idx = dirPath.lastIndexOf("/Standalone/");
        if (idx < 0) {
            return null;
        }
        String libsPath = dirPath.substring(0, idx) + "/Core/";
        File file = new File(libsPath + resourceName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitConnected() throws InterruptedException {
        Object object = this.lock = new Object();
        synchronized (object) {
            this.lock.wait();
        }
        this.lock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectedEvent(ConnectedDebugEvent event) {
        ((JavaDebugRequestClient)this.debugger).setRemote(event.getHost(), event.getPort());
        ((DebugRequestClient)this.debugger).setConnected(true);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void onProcessReadyEvent() {
    }

    public void onWorkerStartedEvent(IWorker thread) {
    }

    public void onWorkerResumedEvent(IWorker thread, ResumeReason reason) {
    }

    public void onWorkerSuspendedEvent(IWorker thread, SuspendReason reason) {
    }

    public void onWorkerCompletedEvent(IWorker thread) {
    }

    public void onProcessTerminatedEvent() {
        this.debugger.notifyTerminated();
    }
}

