/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import prompto.debug.IAcknowledgement;
import prompto.debug.IDebugRequest;
import prompto.debug.IDebugResponse;
import prompto.debug.Serializer;
import prompto.debug.Status;
import prompto.parser.Dialect;
import prompto.parser.ISection;
import prompto.parser.Location;
import prompto.parser.Section;

public class TestDebugMessage {
    @Test
    public void testJsonNonEmpty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        NonEmptyClass o = new NonEmptyClass();
        o.field = "test";
        JsonNode json = mapper.valueToTree((Object)o);
        o = (NonEmptyClass)mapper.treeToValue((TreeNode)json, NonEmptyClass.class);
    }

    @Test
    public void testJsonEmpty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        EmptyClass o = new EmptyClass();
        JsonNode json = mapper.valueToTree((Object)o);
        o = (EmptyClass)mapper.treeToValue((TreeNode)json, EmptyClass.class);
    }

    @Test
    public void testJsonStatusRequest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        IDebugRequest.GetStatusRequest o = new IDebugRequest.GetStatusRequest();
        JsonNode json = mapper.valueToTree((Object)o);
        o = (IDebugRequest.GetStatusRequest)mapper.treeToValue((TreeNode)json, IDebugRequest.GetStatusRequest.class);
    }

    @Test
    public void testStatusRequestMessage() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Serializer.DebugRequestMessage message = new Serializer.DebugRequestMessage();
        message.object = new IDebugRequest.GetStatusRequest();
        message.type = message.object.getType();
        JsonNode json = mapper.valueToTree((Object)message);
        Assert.assertEquals((Object)IDebugRequest.Type.GET_STATUS.name(), (Object)json.get("type").asText());
        Assert.assertNull((Object)json.get("object").get("type"));
        String s = json.toString();
        JsonNode content = mapper.readTree(s);
        String typeName = content.get("type").asText();
        IDebugRequest.Type type = IDebugRequest.Type.valueOf((String)typeName);
        JsonNode object = content.get("object");
        Assert.assertTrue((boolean)(object instanceof ObjectNode));
        IDebugRequest request = (IDebugRequest)mapper.treeToValue((TreeNode)object, type.getKlass());
        Assert.assertTrue((boolean)(request instanceof IDebugRequest.GetStatusRequest));
    }

    @Test
    public void testBreakpointRequestMessage() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Serializer.DebugRequestMessage message = new Serializer.DebugRequestMessage();
        message.object = new IDebugRequest.InstallBreakpointRequest((ISection)new Section("n/a", new Location(12, 18, 22), new Location(12, 22, 14), Dialect.E, true));
        message.type = message.object.getType();
        JsonNode json = mapper.valueToTree((Object)message);
        Assert.assertEquals((Object)IDebugRequest.Type.INSTALL_BREAKPOINT.name(), (Object)json.get("type").asText());
        Assert.assertNull((Object)json.get("object").get("type"));
        String s = json.toString();
        JsonNode content = mapper.readTree(s);
        String typeName = content.get("type").asText();
        IDebugRequest.Type type = IDebugRequest.Type.valueOf((String)typeName);
        JsonNode object = content.get("object");
        Assert.assertTrue((boolean)(object instanceof ObjectNode));
        IDebugRequest request = (IDebugRequest)mapper.treeToValue((TreeNode)object, type.getKlass());
        Assert.assertTrue((boolean)(request instanceof IDebugRequest.InstallBreakpointRequest));
    }

    @Test
    public void testStatusResponseMessage() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Serializer.DebugResponseMessage message = new Serializer.DebugResponseMessage();
        message.object = new IDebugResponse.GetStatusResponse(Status.SUSPENDED);
        message.type = message.object.getType();
        JsonNode json = mapper.valueToTree((Object)message);
        Assert.assertEquals((Object)IDebugResponse.Type.GET_STATUS.name(), (Object)json.get("type").asText());
        Assert.assertNull((Object)json.get("object").get("type"));
        String s = json.toString();
        JsonNode content = mapper.readTree(s);
        String typeName = content.get("type").asText();
        IDebugResponse.Type type = IDebugResponse.Type.valueOf((String)typeName);
        JsonNode object = content.get("object");
        Assert.assertTrue((boolean)(object instanceof ObjectNode));
        IDebugResponse response = (IDebugResponse)mapper.treeToValue((TreeNode)object, type.getKlass());
        Assert.assertTrue((boolean)(response instanceof IDebugResponse.GetStatusResponse));
        Assert.assertEquals((Object)Status.SUSPENDED, (Object)((IDebugResponse.GetStatusResponse)response).getStatus());
    }

    @Test
    public void testOpenStream() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        Serializer.DebugRequestMessage message = new Serializer.DebugRequestMessage();
        message.object = new IDebugRequest.GetStatusRequest();
        message.type = message.object.getType();
        JsonNode json = mapper.valueToTree((Object)message);
        String s = json.toString();
        try (ByteArrayInputStream input = new ByteArrayInputStream(s.getBytes());){
            mapper.readTree((InputStream)input);
            int read = ((InputStream)input).read();
            Assert.assertEquals((long)-1L, (long)read);
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                mapper.writeValue((OutputStream)output, (Object)message);
                output.flush();
                ((OutputStream)output).write(33);
            }
        }
    }

    @Test
    public void testAcknowledgementMessage() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Serializer.AcknowledgementMessage message = new Serializer.AcknowledgementMessage();
        message.type = IAcknowledgement.Type.RECEIVED;
        JsonNode json = mapper.valueToTree((Object)message);
        Assert.assertEquals((Object)IAcknowledgement.Type.RECEIVED.name(), (Object)json.get("type").asText());
        String s = json.toString();
        JsonNode content = mapper.readTree(s);
        String typeName = content.get("type").asText();
        IAcknowledgement.Type type = IAcknowledgement.Type.valueOf((String)typeName);
        IAcknowledgement ack = (IAcknowledgement)type.getKlass().newInstance();
        Assert.assertTrue((boolean)(ack instanceof IAcknowledgement.Acknowledgement));
    }

    static class NonEmptyClass {
        String field;

        NonEmptyClass() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }
    }

    static class EmptyClass {
        EmptyClass() {
        }
    }
}

