/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import java.io.File;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import prompto.nullstore.NullStoreFactory;
import prompto.parser.e.BaseEParserTest;
import prompto.runtime.Application;
import prompto.runtime.utils.Out;
import prompto.utils.IOUtils;
import prompto.utils.ManualTests;

@Category(value={ManualTests.class})
public class TestApplication
extends BaseEParserTest {
    @Test
    public void testLibraryApplication() throws Throwable {
        File testFile = this.tryLocateTestFile("debug/stack.pec");
        this.loadFile(testFile);
        String[] args = new String[]{"-application", "test", "-resources", "\"" + testFile.getAbsolutePath() + "\"", "-loadRuntime", "false"};
        Out.init();
        try {
            Application.main((String[])args);
            Assert.assertEquals((Object)"test123-ok", (Object)this.readLastLine(Out.read()));
        }
        finally {
            Out.restore();
        }
    }

    @Test
    public void testLocalRunApplication() throws Throwable {
        File testFile = this.tryLocateTestFile("debug/stack.pec");
        this.loadFile(testFile);
        String[] args = new String[]{"-codeStoreFactory", NullStoreFactory.class.getName(), "-application", "test", "-resources", "\"" + testFile.getAbsolutePath() + "\""};
        Out.init();
        try {
            Application.main((String[])args);
            Assert.assertEquals((Object)"test123-ok", (Object)this.readLastLine(Out.read()));
        }
        finally {
            Out.restore();
        }
    }

    @Test
    public void testRemoteRunApplication() throws Exception {
        File testFile = this.tryLocateTestFile("debug/stack.pec");
        this.loadFile(testFile);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        File targetDir = this.getDistributionFolder("0.0.1-SNAPSHOT").toFile();
        Assert.assertTrue((String)targetDir.getAbsolutePath(), (boolean)targetDir.exists());
        System.err.println("Distribution: " + targetDir.getAbsolutePath());
        builder.directory(targetDir);
        File outputFile = File.createTempFile("output-", ".txt");
        System.err.println("Output: " + outputFile.getAbsolutePath());
        builder.redirectOutput(outputFile);
        builder.command("java", "-jar", "Standalone-0.0.1-SNAPSHOT.jar", "-codeStoreFactory", NullStoreFactory.class.getName(), "-application", "test", "-resources", "\"" + testFile.getAbsolutePath() + "\"");
        Process process = builder.start();
        process.waitFor();
        Assert.assertEquals((Object)"test123-ok", (Object)this.readLastLine(IOUtils.readFileToString((File)outputFile)));
    }

    @Test
    public void testLocalRunOneTest() throws Throwable {
        File testFile = this.tryLocateTestFile("testing/positive.pec");
        this.loadFile(testFile);
        String[] args = new String[]{"-codeStoreFactory", NullStoreFactory.class.getName(), "-test", "\"Add two numbers\"", "-resources", "\"" + testFile.getAbsolutePath() + "\""};
        Out.init();
        try {
            Application.main((String[])args);
            Assert.assertEquals((Object)"\"Add two numbers\" test successful", (Object)this.readLastLine(Out.read()));
        }
        finally {
            Out.restore();
        }
    }

    @Test
    public void testRemoteRunOneTest() throws Exception {
        File testFile = this.tryLocateTestFile("testing/positive.pec");
        this.loadFile(testFile);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        File targetDir = this.getDistributionFolder("0.0.1-SNAPSHOT").toFile();
        Assert.assertTrue((String)targetDir.getAbsolutePath(), (boolean)targetDir.exists());
        System.err.println("Distribution: " + targetDir.getAbsolutePath());
        builder.directory(targetDir);
        File outputFile = File.createTempFile("output-", ".txt");
        System.err.println("Output: " + outputFile.getAbsolutePath());
        builder.redirectOutput(outputFile);
        builder.command("java", "-jar", "Standalone-0.0.1-SNAPSHOT.jar", "-codeStoreFactory", NullStoreFactory.class.getName(), "-test", "\"Add two numbers\"", "-resources", "\"" + testFile.getAbsolutePath() + "\"");
        Process process = builder.start();
        process.waitFor();
        Assert.assertEquals((Object)"\"Add two numbers\" test successful", (Object)this.readLastLine(IOUtils.readFileToString((File)outputFile)));
    }

    private String readLastLine(String output) {
        String[] lines = output.split("\n");
        return lines.length > 0 ? lines[lines.length - 1] : "";
    }

    private Path getDistributionFolder(String version) {
        File dest = new File(System.getProperty("java.io.tmpdir"), "Prompto/Java/" + version + "/");
        dest.mkdirs();
        return dest.toPath();
    }
}

