/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import prompto.debug.ClientStack;
import prompto.debug.ClientVariable;
import prompto.debug.IDebugRequest;
import prompto.debug.IDebugResponse;
import prompto.debug.IDebugger;
import prompto.debug.IStack;
import prompto.debug.IStackFrame;
import prompto.debug.IThread;
import prompto.debug.IVariable;
import prompto.debug.LeanStack;
import prompto.debug.LeanVariableList;
import prompto.debug.Status;
import prompto.debug.UnreachableException;
import prompto.parser.ISection;

public abstract class DebugRequestClient
implements IDebugger {
    String remoteHost;
    int remotePort;
    boolean connected = false;

    public void setRemote(String host, int port) {
        this.remoteHost = host;
        this.remotePort = port;
        this.connected = true;
    }

    public void setConnected(boolean set) {
        this.connected = set;
    }

    protected IDebugResponse send(IDebugRequest request) {
        return this.sendRequest(request, null);
    }

    protected abstract boolean isRemoteAlive();

    protected abstract IDebugResponse sendRequest(IDebugRequest var1, Consumer<Exception> var2);

    public Status getStatus(IThread thread) {
        if (!this.isRemoteAlive()) {
            return Status.TERMINATED;
        }
        return this.fetchStatus(thread);
    }

    private Status fetchStatus(IThread thread) {
        if (!this.connected) {
            return Status.UNREACHABLE;
        }
        IDebugRequest.GetStatusRequest request = new IDebugRequest.GetStatusRequest(thread);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetStatusResponse) {
            return ((IDebugResponse.GetStatusResponse)response).getStatus();
        }
        return Status.UNREACHABLE;
    }

    public IStack<?> getStack(IThread thread) {
        IDebugRequest.GetStackRequest request = new IDebugRequest.GetStackRequest(thread);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetStackResponse) {
            LeanStack stack = ((IDebugResponse.GetStackResponse)response).getStack();
            return new ClientStack((IDebugger)this, thread, stack);
        }
        throw new UnreachableException();
    }

    public Collection<? extends IVariable> getVariables(IThread thread, IStackFrame frame) {
        IDebugRequest.GetVariablesRequest request = new IDebugRequest.GetVariablesRequest(thread, frame);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetVariablesResponse) {
            LeanVariableList variables = ((IDebugResponse.GetVariablesResponse)response).getVariables();
            return variables.stream().map(v -> new ClientVariable(thread, frame, v)).collect(Collectors.toList());
        }
        throw new UnreachableException();
    }

    public int getLine(IThread thread) {
        IDebugRequest.GetLineRequest request = new IDebugRequest.GetLineRequest(thread);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.GetLineResponse) {
            return ((IDebugResponse.GetLineResponse)response).getLine();
        }
        throw new UnreachableException();
    }

    public boolean isStepping(IThread thread) {
        if (!this.connected) {
            return false;
        }
        IDebugRequest.IsSteppingRequest request = new IDebugRequest.IsSteppingRequest(thread);
        IDebugResponse response = this.send((IDebugRequest)request);
        if (response instanceof IDebugResponse.IsSteppingResponse) {
            return ((IDebugResponse.IsSteppingResponse)response).isStepping();
        }
        throw new UnreachableException();
    }

    public boolean isSuspended(IThread thread) {
        if (!this.connected || this.isTerminated()) {
            return false;
        }
        return this.fetchStatus(thread) == Status.SUSPENDED;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean canResume(IThread thread) {
        return !this.isTerminated() && this.isSuspended(thread);
    }

    public boolean canSuspend(IThread thread) {
        return !this.isTerminated() && !this.isSuspended(thread);
    }

    public boolean canStepInto(IThread thread) {
        return this.isSuspended(thread);
    }

    public boolean canStepOver(IThread thread) {
        return this.isSuspended(thread);
    }

    public boolean canStepOut(IThread thread) {
        return this.isSuspended(thread);
    }

    public void suspend(IThread thread) {
        IDebugRequest.SuspendRequest request = new IDebugRequest.SuspendRequest(thread);
        this.send((IDebugRequest)request);
    }

    public void resume(IThread thread) {
        IDebugRequest.ResumeRequest request = new IDebugRequest.ResumeRequest(thread);
        this.send((IDebugRequest)request);
    }

    public void stepInto(IThread thread) {
        IDebugRequest.StepIntoRequest request = new IDebugRequest.StepIntoRequest(thread);
        this.send((IDebugRequest)request);
    }

    public void stepOut(IThread thread) {
        IDebugRequest.StepOutRequest request = new IDebugRequest.StepOutRequest(thread);
        this.send((IDebugRequest)request);
    }

    public void stepOver(IThread thread) {
        IDebugRequest.StepOverRequest request = new IDebugRequest.StepOverRequest();
        this.send((IDebugRequest)request);
    }

    public void installBreakpoint(ISection section) {
        IDebugRequest.InstallBreakpointRequest request = new IDebugRequest.InstallBreakpointRequest(section);
        this.send((IDebugRequest)request);
    }
}

