/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import prompto.debug.IAcknowledgement;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugEventListener;
import prompto.debug.LocalDebugger;
import prompto.debug.Serializer;

public class JavaDebugEventListener {
    IDebugEventListener listener;
    Thread thread;
    int port = 0;
    boolean listening;

    public JavaDebugEventListener(IDebugEventListener listener) {
        this.listener = listener;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startListening() {
        Object lock = new Object();
        this.thread = new Thread(() -> {
            try (ServerSocket server = new ServerSocket(0);){
                server.setSoTimeout(10);
                this.port = server.getLocalPort();
                LocalDebugger.logEvent((String)("DebugEventServer listening on " + this.port));
                Object object2 = lock;
                synchronized (object2) {
                    lock.notify();
                }
                LocalDebugger.logEvent((String)"DebugEventServer entering loop");
                this.listening = true;
                while (this.listening) {
                    try {
                        Socket client = server.accept();
                        this.handleMessage(client);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                LocalDebugger.logEvent((String)"DebugEventServer exiting loop");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }, "Prompto debug notification listener");
        this.thread.start();
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.port;
    }

    public void stopListening() {
        this.listening = false;
        if (this.thread != Thread.currentThread()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void handleMessage(Socket client) throws Exception {
        InputStream input = client.getInputStream();
        OutputStream output = client.getOutputStream();
        IDebugEvent event = this.readDebugEvent(input);
        LocalDebugger.logEvent((String)("DebugEventServer receives " + event.getType()));
        event.execute(this.listener);
        LocalDebugger.logEvent((String)("DebugEventServer sends " + IAcknowledgement.Type.RECEIVED));
        this.sendAcknowledgement(output);
        output.flush();
    }

    private IDebugEvent readDebugEvent(InputStream input) throws Exception {
        return Serializer.readDebugEvent((InputStream)input);
    }

    private void sendAcknowledgement(OutputStream output) throws Exception {
        Serializer.writeAcknowledgement((OutputStream)output, (IAcknowledgement)new IAcknowledgement.Acknowledgement());
    }

    public boolean isListening() {
        return this.listening;
    }
}

