/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import prompto.debug.DebugRequestClient;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugEventListener;
import prompto.debug.JavaDebugEventListener;
import prompto.debug.JavaDebugRequestClient;
import prompto.debug.ResumeReason;
import prompto.debug.Status;
import prompto.debug.SuspendReason;
import prompto.debug.TestDebuggerBase;
import prompto.store.NullStoreFactory;
import prompto.utils.IOUtils;
import prompto.utils.ManualTests;

@Category(value={ManualTests.class})
public class TestRemoteProcessDebugger
extends TestDebuggerBase
implements IDebugEventListener {
    JavaDebugEventListener eventServer;
    ProcessBuilder builder;
    Process process;
    File outputFile;
    File errorsFile;
    Object lock;

    @Before
    public void before() {
        this.errorsFile = null;
        this.outputFile = null;
    }

    @After
    public void after() throws Exception {
        System.err.println(IOUtils.readFileToString((File)this.errorsFile));
        System.out.println(IOUtils.readFileToString((File)this.outputFile));
        this.process.destroy();
    }

    protected String readOut() throws IOException {
        String output = IOUtils.readFileToString((File)this.outputFile);
        String[] lines = output.split("\n");
        return lines.length > 0 ? lines[lines.length - 1] : "";
    }

    protected void waitSuspendedOrTerminated() throws Exception {
        Status status = this.debugger.getStatus(null);
        while (status != Status.SUSPENDED && status != Status.TERMINATED) {
            Thread.sleep(100L);
            status = this.debugger.getStatus(null);
        }
    }

    protected void start() throws Exception {
        this.process = this.builder.start();
        this.debugger = new JavaDebugRequestClient(this.process, this.eventServer);
        this.waitConnected();
    }

    protected void join() throws Exception {
        this.process.waitFor();
    }

    protected void setDebuggedResource(String resourceName) throws Exception {
        this.eventServer = new JavaDebugEventListener(this);
        int port = this.eventServer.startListening();
        this.builder = new ProcessBuilder(new String[0]);
        File targetDir = this.getDistributionFolder("0.0.1-SNAPSHOT").toFile();
        Assert.assertTrue((String)targetDir.getAbsolutePath(), (boolean)targetDir.exists());
        this.builder.directory(targetDir);
        this.errorsFile = File.createTempFile("errors-", ".txt");
        System.err.println("Errors: " + this.errorsFile.getAbsolutePath());
        this.builder.redirectError(this.errorsFile);
        this.outputFile = File.createTempFile("output-", ".txt");
        System.err.println("Output: " + this.outputFile.getAbsolutePath());
        this.builder.redirectOutput(this.outputFile);
        this.builder.command("java", "-jar", "Standalone-0.0.1-SNAPSHOT.jar", "-runtimeMode", "UNITTEST", "-debug-port", String.valueOf(port), "-codeStore-factory", NullStoreFactory.class.getName(), "-applicationName", "test", "-resourceURLs", this.getResourceAsURL(resourceName).toString());
    }

    private Path getDistributionFolder(String version) {
        File dest = new File(System.getProperty("java.io.tmpdir"), "Prompto/Java/" + version + "/");
        dest.mkdirs();
        return dest.toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitConnected() throws InterruptedException {
        Object object = this.lock = new Object();
        synchronized (object) {
            this.lock.wait();
        }
        this.lock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnectedEvent(IDebugEvent.Connected event) {
        ((JavaDebugRequestClient)this.debugger).setRemote(event.getHost(), event.getPort());
        ((DebugRequestClient)this.debugger).setConnected(true);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void handleResumedEvent(ResumeReason reason) {
    }

    public void handleSuspendedEvent(SuspendReason reason) {
    }

    public void handleTerminatedEvent() {
        this.debugger.notifyTerminated();
    }
}

