/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.QueryableCodeStore;
import prompto.compiler.PromptoClassLoader;
import prompto.config.CmdLineConfigurationReader;
import prompto.config.IConfigurationReader;
import prompto.config.IDebugConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IStandaloneConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.StandaloneConfiguration;
import prompto.config.TempDirectories;
import prompto.config.YamlConfigurationReader;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugEventAdapter;
import prompto.debug.IDebugEventAdapterFactory;
import prompto.debug.IDebugEventListener;
import prompto.debug.IDebugRequestListener;
import prompto.debug.IDebugRequestListenerFactory;
import prompto.debug.LocalDebugger;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoVersion;
import prompto.java.JavaIdentifierExpression;
import prompto.libraries.Libraries;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.runtime.Mode;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.store.memory.MemStore;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.type.TextType;
import prompto.utils.CmdLineParser;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.TypeUtils;
import prompto.value.Dictionary;
import prompto.value.ExpressionValue;
import prompto.value.IValue;
import prompto.value.Text;

public abstract class Standalone {
    private static Logger logger = new Logger();
    private static Context globalContext;
    private static PromptoClassLoader classLoader;

    public static void main(String[] args) throws Throwable {
        IStandaloneConfiguration config = Standalone.loadConfiguration(args);
        Standalone.initialize(config);
        Standalone.run(config);
    }

    private static void run(IStandaloneConfiguration config) throws Throwable {
        IDebugConfiguration debug = config.getDebugConfiguration();
        String testMethod = config.getTestMethod();
        if (testMethod != null) {
            if (debug != null) {
                Standalone.debugTest(debug, testMethod);
            } else {
                Standalone.runTest(testMethod);
            }
        } else {
            String mainMethod = config.getMainMethod();
            IExpression argsValue = Standalone.argsToArgValue(config.getArguments());
            if (debug != null) {
                Standalone.debugApplication(debug, mainMethod, argsValue);
            } else {
                Standalone.runApplication(mainMethod, argsValue);
            }
        }
    }

    private static IStandaloneConfiguration loadConfiguration(String[] args) throws IOException {
        Map argsMap = CmdLineParser.read((String[])args);
        IConfigurationReader reader = Standalone.readerFromArgs(argsMap);
        StandaloneConfiguration config = new StandaloneConfiguration(reader, argsMap);
        return (IStandaloneConfiguration)config.withRuntimeLibs(() -> Libraries.getPromptoLibraries(Libraries.class));
    }

    public static IConfigurationReader readerFromArgs(Map<String, String> argsMap) throws IOException {
        if (argsMap.containsKey("yamlConfigFile")) {
            try (InputStream input = Standalone.loadYamlData(argsMap.get("yamlConfigFile"));){
                YamlConfigurationReader yamlConfigurationReader = new YamlConfigurationReader(input);
                return yamlConfigurationReader;
            }
        }
        return new CmdLineConfigurationReader(argsMap);
    }

    private static InputStream loadYamlData(String path) throws FileNotFoundException {
        File file = new File(path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (resource != null) {
            return resource;
        }
        throw new FileNotFoundException(path);
    }

    public static void initialize(IRuntimeConfiguration config) throws Throwable {
        Mode.set((Mode)config.getRuntimeMode());
        TempDirectories.create();
        ICodeStore codeStore = Standalone.initializeCodeStore(config);
        IStore dataStore = Standalone.initializeDataStore(config);
        Standalone.synchronizeSchema(codeStore, dataStore);
    }

    private static ICodeStore initializeCodeStore(IRuntimeConfiguration config) throws Throwable {
        IStore store = null;
        IStoreConfiguration cfg = config.getCodeStoreConfiguration();
        if (cfg != null) {
            store = IStoreFactory.newStoreFromConfig((IStoreConfiguration)cfg);
        }
        if (store == null) {
            store = new MemStore();
        }
        boolean isMemStore = store instanceof MemStore;
        logger.debug(() -> "Using " + (isMemStore ? "MemStore" : cfg.toString()) + " as code store");
        return Standalone.bootstrapCodeStore(store, config);
    }

    private static IStore initializeDataStore(IRuntimeConfiguration config) throws Throwable {
        IStoreConfiguration cfg = config.getDataStoreConfiguration();
        logger.debug(() -> "Using " + (cfg == null ? "MemStore" : cfg.toString()) + " as data store");
        IStore store = IStoreFactory.newStoreFromConfig((IStoreConfiguration)cfg);
        return Standalone.bootstrapDataStore(store);
    }

    public static Context getGlobalContext() {
        return globalContext;
    }

    public static PromptoClassLoader getClassLoader() {
        return classLoader;
    }

    public static void clearGlobalContext() {
        LocalDebugger debugger = globalContext.getDebugger();
        globalContext = Context.newGlobalContext();
        globalContext.setDebugger(debugger);
        PromptoClassLoader loader = PromptoClassLoader.getInstance();
        if (loader != null) {
            loader.setContext(globalContext);
        }
    }

    private static void runTest(String testMethod) {
        try {
            if ("all".equals(testMethod)) {
                Interpreter.interpretTests((Context)Standalone.getGlobalContext());
            } else {
                Interpreter.interpretTest((Context)Standalone.getGlobalContext(), (Identifier)new Identifier(testMethod), (boolean)true);
            }
        }
        finally {
            Standalone.getGlobalContext().notifyTerminated();
        }
    }

    private static void debugTest(IDebugConfiguration debug, String testMethod) throws Throwable {
        IDebugRequestListener requestListener = Standalone.startDebugging(debug);
        try {
            Standalone.runTest(testMethod);
        }
        finally {
            requestListener.stopListening();
        }
    }

    private static void runApplication(String mainMethod, IExpression args) {
        try {
            Interpreter.interpretMethod((Context)Standalone.getGlobalContext(), (Identifier)new Identifier(mainMethod), (String)"");
        }
        finally {
            Standalone.getGlobalContext().notifyTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugApplication(IDebugConfiguration debug, String mainMethod, IExpression args) throws Throwable {
        IDebugRequestListener server = Standalone.startDebugging(debug);
        try {
            Standalone.runApplication(mainMethod, args);
        }
        finally {
            server.stopListening();
        }
    }

    public static IDebugRequestListener startDebugging(IDebugConfiguration config) throws Throwable {
        IDebugEventAdapter adapter = Standalone.createDebugEventAdapter(config);
        LocalDebugger debugger = new LocalDebugger();
        debugger.setListener((IDebugEventListener)adapter);
        IDebugRequestListener requestListener = Standalone.createDebugRequestListener(config, debugger);
        IDebugEvent.Connected connected = requestListener.startListening();
        Standalone.getGlobalContext().setDebugger(debugger);
        debugger.notifyStarted(connected);
        return requestListener;
    }

    public static IDebugRequestListener createDebugRequestListener(IDebugConfiguration config, LocalDebugger debugger) throws Exception {
        String factoryClassName = config.getRequestListenerFactory();
        if (factoryClassName == null) {
            throw new RuntimeException("Missing requestListenerFactory in debug config!");
        }
        IDebugRequestListenerFactory factory = (IDebugRequestListenerFactory)Class.forName(factoryClassName).newInstance();
        return factory.newInstance(config, debugger);
    }

    public static IDebugEventAdapter createDebugEventAdapter(IDebugConfiguration config) throws Exception {
        String factoryClassName = config.getEventAdapterFactory();
        if (factoryClassName == null) {
            throw new RuntimeException("Missing eventAdapterFactory in debug config!");
        }
        IDebugEventAdapterFactory factory = (IDebugEventAdapterFactory)Class.forName(factoryClassName).newInstance();
        return factory.newInstance(config);
    }

    public static IExpression argsToArgValue(Map<String, String> args) {
        PromptoDict dict = new PromptoDict(true);
        for (Map.Entry<String, String> e : args.entrySet()) {
            dict.put((Object)new Text(e.getKey()), (Object)new Text(e.getValue()));
        }
        return new ExpressionValue((IType)new DictType((IType)TextType.instance()), (IValue)new Dictionary((IType)TextType.instance(), dict));
    }

    public static void showHelp(String application, String test, PromptoVersion version) {
        if (application == null && test == null) {
            logger.info(() -> "Missing argument: -application or -test");
        }
        if (version.equals((Object)PromptoVersion.LATEST)) {
            logger.info(() -> "Additional argument: -version (optional)");
        }
    }

    public static IStore bootstrapDataStore(IStore store) throws Exception {
        DataStore.setGlobal((IStore)store);
        return store;
    }

    public static void synchronizeSchema(ICodeStore codeStore, IStore dataStore) throws PromptoError {
        logger.info(() -> "Initializing schema...");
        Map<String, AttributeDeclaration> columns = Standalone.getMinimalDataColumns(dataStore);
        codeStore.collectStorableAttributes(columns);
        Function<Identifier, IDeclaration> locator = id -> {
            Iterable found = codeStore.fetchLatestDeclarations(id.toString());
            if (found == null) {
                return null;
            }
            Iterator decls = found.iterator();
            return decls.hasNext() ? (IDeclaration)decls.next() : null;
        };
        List infos = columns.values().stream().map(c -> c.getAttributeInfo(locator)).collect(Collectors.toList());
        dataStore.createOrUpdateAttributes(infos);
        logger.info(() -> "Schema successfully initialized.");
    }

    public static ICodeStore bootstrapCodeStore(IStore store, IRuntimeConfiguration config) throws Exception {
        logger.info(() -> "Initializing class loader " + (Mode.get() == Mode.UNITTEST ? "in test mode" : "") + "...");
        globalContext = Context.newGlobalContext();
        classLoader = PromptoClassLoader.initialize((Context)globalContext);
        JavaIdentifierExpression.registerAddOns((URL[])config.getAddOnURLs(), (ClassLoader)classLoader);
        logger.info(() -> "Class loader initialized.");
        logger.info(() -> "Bootstrapping prompto...");
        ICodeStore runtime = config.getRuntimeLibs() == null ? null : ImmutableCodeStore.bootstrapRuntime((Supplier)config.getRuntimeLibs());
        ICodeStore codeStore = Standalone.newQueryableCodeStore(store, runtime, config);
        ICodeStore.setInstance((ICodeStore)codeStore);
        logger.info(() -> "Bootstrapping successful.");
        codeStore.setMainModule(config.getApplicationName(), config.getApplicationVersion());
        return codeStore;
    }

    private static ICodeStore newQueryableCodeStore(IStore store, ICodeStore runtime, IRuntimeConfiguration config) {
        return new QueryableCodeStore(store, runtime, config.getApplicationName(), config.getApplicationVersion(), config.getAddOnURLs(), config.getResourceURLs());
    }

    public static Map<String, AttributeDeclaration> getMinimalDataColumns(IStore dataStore) {
        HashMap<String, AttributeDeclaration> columns = new HashMap<String, AttributeDeclaration>();
        IType dbIdIType = TypeUtils.typeToIType((Type)dataStore.getDbIdClass());
        columns.put("dbId", new AttributeDeclaration(new Identifier("dbId"), dbIdIType));
        columns.put("category", new AttributeDeclaration(new Identifier("category"), (IType)new ListType((IType)TextType.instance()), new IdentifierList(new Identifier("key"))));
        return columns;
    }
}

