/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import prompto.config.IConfigurationReader;
import prompto.config.YamlConfigurationReader;

public class TestYamlConfigurationReader {
    @Test
    public void testThatYamlFileIsParsed() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            Map data = YamlConfigurationReader.parseYaml((InputStream)input);
            Assert.assertNotNull((Object)data);
            Assert.assertNotNull(data.get("simple"));
        }
    }

    @Test
    public void testThatReaderReadsStrings() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            Assert.assertEquals((Object)"some string", (Object)reader.getString("string"));
        }
    }

    @Test
    public void testThatReaderReadsNull() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            Assert.assertNull((Object)reader.getString("empty"));
        }
    }

    @Test
    public void testThatReaderReadsBoolean() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            Assert.assertTrue((boolean)reader.getBoolean("boolean"));
        }
    }

    @Test
    public void testThatReaderReadsInteger() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            Assert.assertEquals((long)23456L, (long)reader.getInteger("integer").intValue());
        }
    }

    @Test
    public void testThatReaderReadsArray() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            Assert.assertEquals(Arrays.asList("abc", "def"), (Object)reader.getArray("array"));
        }
    }

    @Test
    public void testThatReaderReadsObject() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            IConfigurationReader child = reader.getObject("simple");
            Assert.assertEquals((Object)"some string", (Object)child.getString("string"));
            Assert.assertEquals((long)23456L, (long)child.getInteger("integer").intValue());
            Assert.assertEquals(Arrays.asList("abc", "def"), (Object)child.getArray("array"));
        }
    }

    @Test
    public void testThatReaderReadsImported() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("sample.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            IConfigurationReader child = reader.getObject("imported");
            Assert.assertEquals((Object)"some string", (Object)child.getString("string"));
            Assert.assertEquals((Object)"more", (Object)child.getString("more"));
        }
    }
}

