/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.code.ICodeStore;
import prompto.code.QueryableCodeStore;
import prompto.code.Version;
import prompto.compiler.PromptoClassLoader;
import prompto.config.CmdLineConfigurationReader;
import prompto.config.IConfigurationReader;
import prompto.config.IDebugConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IStandaloneConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.StandaloneConfiguration;
import prompto.config.YamlConfigurationReader;
import prompto.debug.DebugEventClient;
import prompto.debug.DebugRequestServer;
import prompto.debug.IDebugEventListener;
import prompto.debug.LocalDebugger;
import prompto.declaration.AttributeDeclaration;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.java.JavaIdentifierExpression;
import prompto.libraries.Libraries;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.store.IDataStore;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.type.TextType;
import prompto.utils.CmdLineParser;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.TypeUtils;
import prompto.value.Dictionary;
import prompto.value.ExpressionValue;
import prompto.value.IValue;
import prompto.value.Text;

public abstract class Standalone {
    private static Logger logger = new Logger();
    private static Context globalContext;
    private static PromptoClassLoader classLoader;

    public static void main(String[] args) throws Throwable {
        IStandaloneConfiguration config = Standalone.loadConfiguration(args);
        Standalone.initialize(config);
        Standalone.run(config);
    }

    private static void run(IStandaloneConfiguration config) throws Throwable {
        IDebugConfiguration debug = config.getDebugConfiguration();
        String testMethod = config.getTestMethod();
        if (testMethod != null) {
            if (debug != null) {
                Standalone.debugTest(debug, testMethod);
            } else {
                Standalone.runTest(testMethod);
            }
        } else {
            String mainMethod = config.getMainMethod();
            IExpression argsValue = Standalone.argsToArgValue(config.getArguments());
            if (debug != null) {
                Standalone.debugApplication(debug, mainMethod, argsValue);
            } else {
                Standalone.runApplication(mainMethod, argsValue);
            }
        }
    }

    private static IStandaloneConfiguration loadConfiguration(String[] args) throws FileNotFoundException {
        Map argsMap = CmdLineParser.parse((String[])args);
        IConfigurationReader reader = Standalone.readerFromArgs(argsMap);
        StandaloneConfiguration config = new StandaloneConfiguration(reader, argsMap);
        config.setRuntimeLibsSupplier(() -> Libraries.getPromptoLibraries(Libraries.class));
        return config;
    }

    public static IConfigurationReader readerFromArgs(Map<String, String> argsMap) throws FileNotFoundException {
        if (argsMap.containsKey("yamlConfigFile")) {
            return new YamlConfigurationReader(new FileInputStream(argsMap.get("yamlConfigFile")));
        }
        return new CmdLineConfigurationReader(argsMap);
    }

    public static void initialize(IRuntimeConfiguration config) throws Throwable {
        IStoreConfiguration tmp = config.getCodeStoreConfiguration();
        IStoreConfiguration cfg = tmp != null ? tmp : (config.isLoadRuntime() ? null : IStoreConfiguration.NULL_STORE_CONFIG);
        logger.info(() -> "Using " + (cfg == null ? "MemStore" : cfg.toString()) + " as code store");
        IStore store = IStoreFactory.newStoreFromConfig((IStoreConfiguration)cfg);
        ICodeStore codeStore = Standalone.bootstrapCodeStore(store, config);
        IStoreConfiguration cfg2 = config.getDataStoreConfiguration();
        logger.info(() -> "Using " + (cfg2 == null ? "MemStore" : cfg2.toString()) + " as data store");
        store = IStoreFactory.newStoreFromConfig((IStoreConfiguration)cfg2);
        IStore dataStore = Standalone.bootstrapDataStore(store);
        Standalone.synchronizeSchema(codeStore, dataStore);
    }

    public static Context getGlobalContext() {
        return globalContext;
    }

    public static PromptoClassLoader getClassLoader() {
        return classLoader;
    }

    public static void clearGlobalContext() {
        globalContext = Context.newGlobalContext();
        PromptoClassLoader loader = PromptoClassLoader.getInstance();
        if (loader != null) {
            loader.setContext(globalContext);
        }
    }

    private static void runTest(String testMethod) {
        try {
            if ("all".equals(testMethod)) {
                Interpreter.interpretTests((Context)Standalone.getGlobalContext());
            } else {
                Interpreter.interpretTest((Context)Standalone.getGlobalContext(), (Identifier)new Identifier(testMethod), (boolean)true);
            }
        }
        finally {
            Standalone.getGlobalContext().notifyTerminated();
        }
    }

    private static void debugTest(IDebugConfiguration debug, String testMethod) throws Throwable {
        DebugRequestServer server = Standalone.startDebugging(debug.getHost(), debug.getPort());
        try {
            Standalone.runTest(testMethod);
        }
        finally {
            server.stopListening();
        }
    }

    private static void runApplication(String mainMethod, IExpression args) {
        try {
            Interpreter.interpretMethod((Context)Standalone.getGlobalContext(), (Identifier)new Identifier(mainMethod), (String)"");
        }
        finally {
            Standalone.getGlobalContext().notifyTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugApplication(IDebugConfiguration debug, String mainMethod, IExpression args) throws Throwable {
        DebugRequestServer server = Standalone.startDebugging(debug.getHost(), debug.getPort());
        try {
            Standalone.runApplication(mainMethod, args);
        }
        finally {
            server.stopListening();
        }
    }

    public static DebugRequestServer startDebugging(String debugHost, Integer debugPort) throws Throwable {
        LocalDebugger debugger = new LocalDebugger();
        debugger.setListener((IDebugEventListener)new DebugEventClient(debugHost, debugPort.intValue()));
        DebugRequestServer server = Standalone.startDebuggerThread(debugger);
        Standalone.getGlobalContext().setDebugger(debugger);
        debugger.notifyStarted("localhost", server.getPort());
        return server;
    }

    public static DebugRequestServer startDebuggerThread(LocalDebugger debugger) throws Exception {
        DebugRequestServer server = new DebugRequestServer(debugger);
        server.startListening();
        return server;
    }

    public static IExpression argsToArgValue(Map<String, String> args) {
        PromptoDict dict = new PromptoDict(true);
        for (Map.Entry<String, String> e : args.entrySet()) {
            dict.put((Object)new Text(e.getKey()), (Object)new Text(e.getValue()));
        }
        return new ExpressionValue((IType)new DictType((IType)TextType.instance()), (IValue)new Dictionary((IType)TextType.instance(), dict));
    }

    public static void showHelp(String application, String test, Version version) {
        if (application == null && test == null) {
            logger.info(() -> "Missing argument: -application or -test");
        }
        if (version.equals((Object)Version.LATEST)) {
            logger.info(() -> "Additional argument: -version (optional)");
        }
    }

    public static IStore bootstrapDataStore(IStore store) {
        IDataStore.setInstance((IStore)store);
        return store;
    }

    public static void synchronizeSchema(ICodeStore codeStore, IStore dataStore) throws PromptoError {
        logger.info(() -> "Initializing schema...");
        Map<String, AttributeDeclaration> columns = Standalone.getMinimalDataColumns(dataStore);
        codeStore.collectStorableAttributes(columns);
        List infos = columns.values().stream().map(c -> c.getAttributeInfo()).collect(Collectors.toList());
        dataStore.createOrUpdateColumns(infos);
        logger.info(() -> "Schema successfully initialized.");
    }

    public static ICodeStore bootstrapCodeStore(IStore store, IRuntimeConfiguration config) throws Exception {
        logger.info(() -> "Initializing class loader " + (config.isTestMode() ? "in test mode" : "") + "...");
        globalContext = Context.newGlobalContext();
        File promptoDir = Files.createTempDirectory("prompto_", new FileAttribute[0]).toFile();
        classLoader = PromptoClassLoader.initialize((Context)globalContext, (File)promptoDir, (boolean)config.isTestMode());
        JavaIdentifierExpression.registerAddOns((URL[])config.getAddOnURLs(), (ClassLoader)classLoader);
        logger.info(() -> "Class loader initialized.");
        logger.info(() -> "Bootstrapping prompto...");
        ICodeStore codeStore = Standalone.newQueryableCodeStore(store, config);
        ICodeStore.setInstance((ICodeStore)codeStore);
        logger.info(() -> "Bootstrapping successful.");
        return codeStore;
    }

    private static ICodeStore newQueryableCodeStore(IStore store, IRuntimeConfiguration config) {
        return new QueryableCodeStore(store, config.getRuntimeLibsSupplier(), config.getApplicationName(), config.getApplicationVersion(), config.getAddOnURLs(), config.getResourceURLs());
    }

    public static Map<String, AttributeDeclaration> getMinimalDataColumns(IStore dataStore) {
        HashMap<String, AttributeDeclaration> columns = new HashMap<String, AttributeDeclaration>();
        IType dbIdIType = TypeUtils.typeToIType((Type)dataStore.getDbIdClass());
        columns.put("dbId", new AttributeDeclaration(new Identifier("dbId"), dbIdIType));
        columns.put("category", new AttributeDeclaration(new Identifier("category"), (IType)new ListType((IType)TextType.instance()), new IdentifierList(new Identifier("key"))));
        return columns;
    }
}

