/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import prompto.code.Version;
import prompto.config.DebugConfiguration;
import prompto.config.IConfigurationReader;
import prompto.config.IDebugConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IStoreConfiguration;

public class RuntimeConfiguration
implements IRuntimeConfiguration {
    IConfigurationReader reader;
    Map<String, String> arguments;
    Supplier<Collection<URL>> runtimeLibsSupplier;

    protected RuntimeConfiguration(IConfigurationReader reader, Map<String, String> arguments) {
        this.reader = reader;
        this.arguments = arguments;
    }

    public IDebugConfiguration getDebugConfiguration() {
        IConfigurationReader child = this.reader.getObject("debug");
        return child == null ? null : new DebugConfiguration(child);
    }

    public IStoreConfiguration getCodeStoreConfiguration() {
        return this.reader.readStoreConfiguration("codeStore");
    }

    public IStoreConfiguration getDataStoreConfiguration() {
        return this.reader.readStoreConfiguration("dataStore");
    }

    public Supplier<Collection<URL>> getRuntimeLibsSupplier() {
        return this.runtimeLibsSupplier;
    }

    public void setRuntimeLibsSupplier(Supplier<Collection<URL>> supplier) {
        this.runtimeLibsSupplier = supplier;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public boolean isTestMode() {
        return this.reader.getBooleanOrDefault("testMode", false);
    }

    public boolean isLoadRuntime() {
        return this.reader.getBooleanOrDefault("loadRuntime", true);
    }

    public URL[] getAddOnURLs() {
        return this.getURLs("addOnURLs");
    }

    public String getApplicationName() {
        return this.reader.getString("applicationName");
    }

    public Version getApplicationVersion() {
        String version = this.reader.getString("applicationVersion");
        return version == null ? Version.LATEST : Version.parse((String)version);
    }

    public URL[] getResourceURLs() {
        return this.getURLs("resourceURLs");
    }

    private URL[] getURLs(String key) {
        List list = this.reader.getArray(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        URL[] urls = new URL[list.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = RuntimeConfiguration.convertToURL(list.get(i).toString());
        }
        return urls;
    }

    private static URL convertToURL(String resourceName) {
        try {
            if (resourceName.startsWith("\"")) {
                resourceName = resourceName.substring(1);
            }
            if (resourceName.endsWith("\"")) {
                resourceName = resourceName.substring(0, resourceName.length() - 1);
            }
            if (resourceName.startsWith("file:") || resourceName.startsWith("jar:")) {
                return new URL(resourceName);
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            if (url != null) {
                return url;
            }
            File file = new File(resourceName);
            if (!file.exists()) {
                throw new FileNotFoundException(resourceName);
            }
            return file.toURI().toURL();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

