/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.config.IConfigurationReader;

public class CmdLineConfigurationReader
implements IConfigurationReader {
    Map<String, String> argsMap;

    public CmdLineConfigurationReader(Map<String, String> argsMap) {
        this.argsMap = argsMap;
    }

    public String toString() {
        return this.argsMap.toString();
    }

    public Boolean getBoolean(String key) {
        String value = this.argsMap.get(key);
        return value == null ? null : Boolean.valueOf(value);
    }

    public String getString(String key) {
        return this.argsMap.get(key);
    }

    public Integer getInteger(String key) {
        String value = this.argsMap.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public <T> List<T> getArray(String key) {
        String value = this.argsMap.get(key);
        if (value == null) {
            return null;
        }
        return Arrays.asList(value.split(","));
    }

    public IConfigurationReader getObject(String key) {
        String prefix = key + "-";
        Map<String, String> subMap = this.argsMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), e -> (String)e.getValue()));
        return subMap.isEmpty() ? null : new CmdLineConfigurationReader(subMap);
    }
}

