/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import prompto.config.IConfigurationReader;

public class YamlConfigurationReader
implements IConfigurationReader {
    Map<String, Object> data;

    static Map<String, Object> parseYaml(InputStream input) {
        try {
            YamlReader reader = new YamlReader((Reader)new InputStreamReader(input));
            return (Map)reader.read(Map.class);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public YamlConfigurationReader(InputStream input) {
        this(YamlConfigurationReader.parseYaml(input));
    }

    public YamlConfigurationReader(Map<String, Object> data) {
        if (data.containsKey("<<")) {
            this.data = new HashMap<String, Object>();
            this.data.putAll((Map)data.get("<<"));
            this.data.putAll(data);
            this.data.remove("<<");
        } else {
            this.data = data;
        }
    }

    public String getString(String key) {
        Object value = this.data.get(key);
        return value == null ? null : value.toString();
    }

    public Boolean getBoolean(String key) {
        Object value = this.data.get(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
    }

    public Integer getInteger(String key) {
        Object value = this.data.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value.toString()));
    }

    public <T> List<T> getArray(String key) {
        Object value = this.data.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return null;
    }

    public IConfigurationReader getObject(String key) {
        Object value = this.data.get(key);
        return value instanceof Map ? new YamlConfigurationReader((Map)value) : null;
    }
}

