/*
 * Decompiled with CFR 0.152.
 */
package prompto.cloud;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.cloud.Cloud;

class AwsHelper
implements Cloud.Helper {
    private Boolean isAWS = null;

    AwsHelper() {
    }

    @Override
    public boolean checkHost() {
        if (this.isAWS == null) {
            this.isAWS = this.checkIsAWS();
        }
        return this.isAWS;
    }

    @Override
    public Collection<URL> getJarURLs() {
        File awsDir = new File("/AwsClient/");
        if (awsDir.exists()) {
            return Stream.of(awsDir.listFiles()).filter(file -> file.isFile()).filter(file -> file.getAbsolutePath().endsWith(".jar")).map(File::toURI).map(this::safeURItoURL).collect(Collectors.toList());
        }
        return null;
    }

    URL safeURItoURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean checkIsAWS() {
        try (FileReader reader = new FileReader("/sys/devices/virtual/dmi/id/bios_version");
             BufferedReader buffer = new BufferedReader(reader);){
            String line;
            do {
                if ((line = buffer.readLine()) != null) continue;
                Boolean bl = false;
                return bl;
            } while (!line.toLowerCase().contains("amazon"));
            Boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isInClassPath() {
        try {
            Class.forName("prompto.aws.EC2");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

