/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import prompto.debug.IDebugEventListener;
import prompto.debug.Serializer;
import prompto.debug.ack.Acknowledged;
import prompto.debug.event.IDebugEvent;
import prompto.utils.Logger;

public class JavaDebugEventListener {
    private static Logger logger = new Logger();
    IDebugEventListener listener;
    Thread thread;
    int port = 0;
    boolean listening;

    public JavaDebugEventListener(IDebugEventListener listener) {
        this.listener = listener;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startListening() {
        Object lock = new Object();
        this.thread = new Thread(() -> {
            try (ServerSocket server = new ServerSocket(0);){
                server.setSoTimeout(10);
                this.port = server.getLocalPort();
                logger.debug(() -> "DebugEventServer listening on " + this.port);
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
                logger.debug(() -> "DebugEventServer entering loop");
                this.listening = true;
                while (this.listening) {
                    try {
                        Socket client = server.accept();
                        try {
                            this.handleMessage(client);
                        }
                        finally {
                            if (client == null) continue;
                            client.close();
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                logger.debug(() -> "DebugEventServer exiting loop");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }, "Prompto debug notification listener");
        this.thread.start();
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.port;
    }

    public void stopListening() {
        this.listening = false;
        if (this.thread != Thread.currentThread()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void handleMessage(Socket client) throws Exception {
        try (InputStream input = client.getInputStream();
             OutputStream output = client.getOutputStream();){
            IDebugEvent event = this.readDebugEvent(input);
            logger.debug(() -> "DebugEventServer receives " + event.getClass().getName());
            event.execute(this.listener);
            logger.debug(() -> "DebugEventServer sends " + event.getClass().getName());
            this.sendAcknowledged(output);
            output.flush();
        }
    }

    private IDebugEvent readDebugEvent(InputStream input) throws Exception {
        return Serializer.readDebugEvent((InputStream)input);
    }

    private void sendAcknowledged(OutputStream output) throws Exception {
        Serializer.writeMessage((OutputStream)output, (Object)new Acknowledged());
    }

    public boolean isListening() {
        return this.listening;
    }
}

