/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.agent2;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.apache.commons.beanutils.MethodUtils;
import org.provarules.agent2.ProvaReagent;
import org.provarules.agent2.ProvaThreadpoolEnum;
import org.provarules.api2.ProvaCommunicator;
import org.provarules.esb2.ProvaAgent;
import org.provarules.exchange.ProvaSolution;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.messaging.ProvaMessenger;
import org.provarules.kernel2.messaging.ProvaWorkflows;
import org.provarules.parser2.ProvaParsingException;
import org.provarules.reference2.ProvaKnowledgeBaseImpl;
import org.provarules.reference2.ProvaResolutionInferenceEngineImpl;
import org.provarules.reference2.ProvaSwingAdaptor;
import org.provarules.reference2.messaging.ProvaMessengerImpl;
import org.provarules.reference2.messaging.ProvaWorkflowsImpl;
import org.provarules.service.ProvaMiniService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaReagentImpl
implements ProvaReagent {
    private static final Logger log = LoggerFactory.getLogger(ProvaReagentImpl.class);
    private static final ProvaSolution[] noSolutions = new ProvaSolution[0];
    private String agent;
    private String password;
    private String port;
    private ProvaKnowledgeBase kb;
    private String machine;
    private final ExecutorService executor;
    private final ExecutorService pool;
    private final ExecutorService[] partitionedPool = new ExecutorService[32];
    private final Map<Long, Integer> threadId2Index = new HashMap<Long, Integer>(32);
    private ProvaMessenger messenger;
    private List<ProvaSolution[]> initializationSolutions;
    private ProvaWorkflows workflows;
    private ProvaSwingAdaptor swingAdaptor;
    private long latestTimestamp;
    private boolean allowedShutdown = true;

    public ProvaReagentImpl(ProvaCommunicator communicator, ProvaMiniService service, String agent, String port, String[] prot, Object rules, boolean async, ProvaAgent esb, Map<String, Object> globals) {
        this.agent = agent;
        this.port = port;
        try {
            this.machine = InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.kb = new ProvaKnowledgeBaseImpl();
        this.kb.setGlobals(globals);
        this.executor = Executors.newFixedThreadPool(1, r -> {
            Thread th = new Thread(r);
            th.setName("Sync");
            th.setDaemon(true);
            return th;
        });
        this.pool = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueueWithPut<Runnable>(81920));
        for (int i = 0; i < this.partitionedPool.length; ++i) {
            int index = i;
            this.partitionedPool[i] = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueueWithPut<Runnable>(81920), r -> {
                Thread th = new Thread(r);
                this.threadId2Index.put(th.getId(), index);
                th.setName("Async-" + (index + 1));
                th.setDaemon(true);
                return th;
            });
        }
        this.messenger = new ProvaMessengerImpl(this, this.kb, agent, this.password, this.machine, esb);
        this.messenger.setService(service);
        communicator.setMessenger(this.messenger);
        this.workflows = new ProvaWorkflowsImpl(this.kb);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        if (rules != null && !rules.equals("")) {
            try {
                this.initializationSolutions = rules instanceof String ? this.consultSync((String)rules, (String)rules, new Object[0]).get() : this.consultSync((BufferedReader)rules, "-1", new Object[0]).get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof ProvaParsingException) {
                    throw new RuntimeException(e.getCause());
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            finally {
                if (this.initializationSolutions == null) {
                    this.shutdown();
                }
            }
        }
    }

    @Override
    public List<ProvaSolution[]> getInitializationSolutions() {
        return this.initializationSolutions;
    }

    private void cleanUp() {
    }

    private List<ProvaSolution[]> consultSyncInternal(BufferedReader in, String key, Object[] objects) {
        return this.kb.consultSyncInternal((ProvaReagent)this, in, key, objects);
    }

    private List<ProvaSolution[]> consultSyncInternal(String src, String key, Object[] objects) {
        return this.kb.consultSyncInternal((ProvaReagent)this, src, key, objects);
    }

    @Override
    public Future<List<ProvaSolution[]>> consultSync(String src, String key, Object[] objects) {
        Callable<List> task = () -> this.consultSyncInternal(src, key, objects);
        FutureTask<List<ProvaSolution[]>> ftask = new FutureTask<List<ProvaSolution[]>>(task);
        Future<?> future = this.executor.submit(ftask);
        return ftask;
    }

    @Override
    public Future<List<ProvaSolution[]>> consultSync(BufferedReader in, String key, Object[] objects) {
        Callable<List> task = () -> this.consultSyncInternal(in, key, objects);
        FutureTask<List<ProvaSolution[]>> ftask = new FutureTask<List<ProvaSolution[]>>(task);
        this.executor.submit(ftask);
        return ftask;
    }

    @Override
    public void consultAsync(String src, String key, Object[] objects) {
        StringReader sr = new StringReader(src);
        BufferedReader in = new BufferedReader(sr);
        Runnable task = () -> this.consultSyncInternal(in, key, objects);
        this.executor.submit(task);
    }

    @Override
    public void consultAsync(BufferedReader in, String key, Object[] objects) {
        Runnable task = () -> this.consultSyncInternal(in, key, objects);
        this.executor.submit(task);
    }

    @Override
    public void submitAsync(long partition, ProvaRule goal, ProvaThreadpoolEnum threadPool) {
        this.latestTimestamp = System.currentTimeMillis();
        Runnable job = () -> {
            try {
                this.submitSyncInternal(goal);
            }
            catch (RuntimeException e) {
                log.error("Runtime Java exception: " + e);
            }
        };
        switch (threadPool) {
            case MAIN: {
                if (this.executor.isShutdown()) {
                    return;
                }
                try {
                    this.executor.execute(job);
                }
                catch (RejectedExecutionException r) {
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.executor.execute(job);
                }
                break;
            }
            case TASK: {
                if (this.pool.isShutdown()) {
                    return;
                }
                try {
                    this.pool.execute(job);
                }
                catch (RejectedExecutionException r) {
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.pool.execute(job);
                }
                break;
            }
            case SWING: {
                Runnable task = () -> this.submitSyncInternal(goal);
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        task.run();
                        break;
                    }
                    SwingUtilities.invokeAndWait(task);
                }
                catch (InterruptedException | InvocationTargetException exception) {}
                break;
            }
            case CONVERSATION: {
                ExecutorService executorService = this.partitionedPool[this.threadIndex(partition)];
                if (executorService.isShutdown()) {
                    return;
                }
                try {
                    executorService.execute(job);
                    break;
                }
                catch (RejectedExecutionException r) {
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    executorService.execute(job);
                }
            }
        }
    }

    private int threadIndex(long partition) {
        return (int)(partition % (long)this.partitionedPool.length);
    }

    @Override
    public void executeTask(long partition, Runnable task, ProvaThreadpoolEnum threadPool) {
        switch (threadPool) {
            case MAIN: {
                this.executor.execute(task);
                break;
            }
            case CONVERSATION: {
                this.partitionedPool[this.threadIndex(partition)].execute(task);
                break;
            }
            case SWING: {
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        task.run();
                        break;
                    }
                    SwingUtilities.invokeAndWait(task);
                }
                catch (InterruptedException | InvocationTargetException exception) {}
                break;
            }
            case TASK: {
                this.pool.execute(task);
            }
        }
    }

    @Override
    public boolean spawn(ProvaList terms) {
        ProvaObject[] data = terms.getFixed();
        int length = data.length;
        if (length < 4) {
            return false;
        }
        if (!(data[0] instanceof ProvaConstant)) {
            return false;
        }
        if (!(data[2] instanceof ProvaConstant)) {
            return false;
        }
        String method = (String)((ProvaConstant)data[2]).getObject();
        if (!(data[1] instanceof ProvaConstant)) {
            return false;
        }
        Object target = ((ProvaConstant)data[1]).getObject();
        Object[] args0 = null;
        ProvaObject argsRaw = data[3];
        if (argsRaw instanceof ProvaList) {
            ProvaList argsList = (ProvaList)argsRaw;
            args0 = new Object[argsList.getFixed().length];
            for (int i = 0; i < args0.length; ++i) {
                ProvaObject po = argsList.getFixed()[i];
                if (!(po instanceof ProvaConstant)) {
                    return false;
                }
                args0[i] = ((ProvaConstant)po).getObject();
            }
        } else if (argsRaw instanceof ProvaConstant) {
            args0 = new Object[]{((ProvaConstant)argsRaw).getObject()};
        }
        Object[] args = args0;
        Callable<Object> task = () -> {
            Object ret;
            if (target instanceof Class) {
                Class targetClass = (Class)target;
                ret = MethodUtils.invokeStaticMethod((Class)targetClass, (String)method, (Object[])args);
            } else {
                ret = MethodUtils.invokeMethod((Object)target, (String)method, (Object[])args);
            }
            this.messenger.sendReturnAsMsg((ProvaConstant)data[0], ret);
            return ret;
        };
        Future<Object> future = this.pool.submit(task);
        return true;
    }

    private void submitSyncInternal(ProvaRule goal) {
        ProvaResolutionInferenceEngineImpl engine = new ProvaResolutionInferenceEngineImpl(this.kb, goal);
        engine.setReagent(this);
        ProvaDerivationNode result = engine.run();
    }

    @Override
    public void setPrintWriter(PrintWriter printWriter) {
        this.kb.setPrintWriter(printWriter);
    }

    @Override
    public ProvaMessenger getMessenger() {
        return this.messenger;
    }

    @Override
    public ProvaKnowledgeBase getKb() {
        return this.kb;
    }

    @Override
    public String getAgent() {
        return this.agent;
    }

    @Override
    public void shutdown() {
        this.messenger.stop();
        this.pool.shutdown();
        for (ExecutorService partitioned : this.partitionedPool) {
            partitioned.shutdown();
            partitioned = null;
        }
        this.executor.shutdown();
    }

    @Override
    public ProvaWorkflows getWorkflows() {
        return this.workflows;
    }

    @Override
    public void unconsultSync(String src) {
        this.kb.unconsultSync(src);
    }

    @Override
    public ProvaSwingAdaptor getSwingAdaptor() {
        if (this.swingAdaptor == null) {
            this.swingAdaptor = new ProvaSwingAdaptor(this);
        }
        return this.swingAdaptor;
    }

    @Override
    public boolean canShutdown() {
        return this.allowedShutdown && System.currentTimeMillis() > this.latestTimestamp + 1000L;
    }

    @Override
    public void setAllowedShutdown(boolean allowedShutdown) {
        this.allowedShutdown = allowedShutdown;
    }

    @Override
    public boolean isInPartitionThread(long partition) {
        return this.threadId2Index.get(Thread.currentThread().getId()).intValue() == this.threadIndex(partition);
    }

    @Override
    public void setGlobalConstant(String name, Object value) {
        this.kb.setGlobalConstant(name, value);
    }

    private class ArrayBlockingQueueWithPut<E>
    extends ArrayBlockingQueue<E> {
        private static final long serialVersionUID = -3392821517081645923L;

        ArrayBlockingQueueWithPut(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
            }
            catch (InterruptedException e1) {
                log.info("Interrupted asynchronous thread");
            }
            return true;
        }
    }
}

