/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.examples;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Order
implements Serializable {
    private static final long serialVersionUID = 8634610276409403898L;
    private String customer;
    private List<Object> items;
    private Map<Object, Double> discounts;

    public Order(String customer) {
        this.customer = customer;
        this.items = new ArrayList<Object>();
        this.discounts = new HashMap<Object, Double>();
    }

    public String toString() {
        StringBuilder res = new StringBuilder("Order(" + this.customer + ",(");
        for (int i = 0; i < this.items.size(); ++i) {
            if (i != 0) {
                res.append(',');
            }
            Object item = this.items.get(i);
            res.append(item).append(":").append(this.discounts.get(item));
        }
        res.append("))");
        return res.toString();
    }

    public String getCustomer() {
        return this.customer;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void addItem(Object item) {
        this.items.add(item);
        this.discounts.put(item, 1.0);
    }

    public void setDiscount(String item, double d) {
        Double discount0 = this.discounts.get(item);
        if (discount0 == null) {
            this.discounts.put(item, 1.0 - d);
            return;
        }
        this.discounts.put(item, discount0 * (1.0 - d));
    }
}

