/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.Arrays;
import java.util.List;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaListPtr;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaListImpl;

public class ProvaListPtrImpl
implements ProvaListPtr {
    private static final long serialVersionUID = 4407774077342578415L;
    private ProvaList assigned;
    private int offset;

    public ProvaListPtrImpl(ProvaList assigned, int offset) {
        this.assigned = assigned;
        this.offset = offset;
    }

    public void setAssigned(ProvaList assigned) {
        this.assigned = assigned;
    }

    @Override
    public ProvaList getAssigned() {
        return this.assigned;
    }

    @Override
    public ProvaList getAssignedWithOffset() {
        if (this.offset == 0) {
            return this.assigned;
        }
        if (this.offset < this.assigned.getFixed().length) {
            ProvaObject[] newFixed = Arrays.copyOfRange(this.assigned.getFixed(), this.offset, this.assigned.getFixed().length);
            return ProvaListImpl.create(newFixed, this.assigned.getTail());
        }
        if (this.offset == this.assigned.getFixed().length) {
            return ProvaListImpl.create(null, this.assigned.getTail());
        }
        return ProvaListImpl.emptyRList;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public ProvaObject getRecursivelyAssigned() {
        return this;
    }

    @Override
    public int collectVariables(long ruleId, List<ProvaVariable> variables) {
        return this.assigned.collectVariables(ruleId, variables);
    }

    @Override
    public int computeSize() {
        return this.assigned.computeSize(this.offset);
    }

    @Override
    public boolean unify(ProvaObject target, ProvaUnification unification) {
        return this.assigned.unify(this.offset, target, unification);
    }

    @Override
    public ProvaObject rebuild(ProvaUnification unification) {
        return this.assigned.rebuild(unification, this.offset);
    }

    @Override
    public ProvaObject rebuildSource(ProvaUnification unification) {
        return this.assigned.rebuildSource(unification, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = this.offset; i < this.assigned.getFixed().length; ++i) {
            if (i != this.offset) {
                sb.append(',');
            }
            sb.append(this.assigned.getFixed()[i]);
        }
        if (this.assigned.getTail() != null) {
            sb.append('|');
            sb.append(this.assigned.getTail());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void substituteVariables(ProvaVariablePtr[] varsMap) {
        this.assigned.substituteVariables(varsMap);
    }

    @Override
    public boolean isGround() {
        return this.assigned.isGround();
    }

    @Override
    public String toString(List<ProvaVariable> variables) {
        return this.toString();
    }

    @Override
    public ProvaObject cloneWithBoundVariables(List<ProvaVariable> variables, List<Boolean> isConstant) {
        ProvaObject[] fixed = this.assigned.getFixed();
        ProvaObject[] newFixed = new ProvaObject[fixed.length - this.offset];
        System.arraycopy(fixed, this.offset, newFixed, 0, newFixed.length);
        return ProvaListImpl.create(newFixed).cloneWithBoundVariables(variables, isConstant);
    }

    @Override
    public ProvaObject cloneWithVariables(List<ProvaVariable> variables) {
        if (this.assigned != null) {
            return this.assigned.cloneWithVariables(variables);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ProvaObject cloneWithVariables(long ruleId, List<ProvaVariable> variables) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object computeIfExpression() {
        return this;
    }

    @Override
    public ProvaObject computeProvaIfExpression() {
        return this;
    }

    @Override
    public boolean updateGround(List<ProvaVariable> variables) {
        return this.assigned.updateGround(variables);
    }
}

