/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaGuardedLiteralImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaRuleImpl
implements ProvaRule {
    private static final Logger log = LoggerFactory.getLogger((String)"prova");
    private long ruleId;
    private List<ProvaVariable> variables = new ArrayList<ProvaVariable>();
    private ProvaLiteral head;
    private ProvaLiteral[] body;
    private int offset = 0;
    private Object firstArg;
    private boolean removed = false;
    private int cut = 0;
    private String sourceCode;
    private Map<String, List<Object>> metadata;
    private int line;

    private ProvaRuleImpl() {
    }

    public ProvaRuleImpl(long ruleId, ProvaLiteral head, ProvaLiteral[] body) {
        this.ruleId = ruleId;
        this.setHead(head);
        this.body = body;
        if (ruleId != 0L) {
            this.collectVariables();
        }
        for (ProvaVariable variable : this.variables) {
            variable.setRuleId(ruleId);
        }
        if (this.head != null) {
            this.head.addClause(this);
        }
        if (log.isDebugEnabled()) {
            this.getSourceCode();
        }
    }

    public ProvaRuleImpl(long ruleId, ProvaLiteral head, ProvaLiteral[] body, boolean addInFront) {
        this.ruleId = ruleId;
        this.setHead(head);
        this.body = body;
        if (ruleId != 0L) {
            this.collectVariables();
        }
        for (ProvaVariable variable : this.variables) {
            variable.setRuleId(ruleId);
        }
        if (this.head != null) {
            this.head.addClauseA(this);
        }
    }

    public static ProvaRule createVirtualRule(long ruleId, ProvaLiteral head, ProvaLiteral[] body) {
        ProvaRuleImpl newRule = new ProvaRuleImpl();
        newRule.ruleId = ruleId;
        newRule.setHead(head);
        newRule.body = body;
        if (ruleId != 0L) {
            newRule.collectVariables();
        }
        for (ProvaVariable variable : newRule.variables) {
            variable.setRuleId(ruleId);
        }
        return newRule;
    }

    public ProvaRuleImpl(ProvaLiteral[] body) {
        this.ruleId = 0L;
        this.body = body;
        this.collectVariables();
        for (ProvaVariable variable : this.variables) {
            variable.setRuleId(this.ruleId);
        }
        if (this.head != null) {
            this.head.addClause(this);
        }
    }

    private ProvaRuleImpl(ProvaRuleImpl o) {
        this.ruleId = o.ruleId;
        this.variables = o.cloneVariables();
        this.setHead(o.head);
        if (o.offset != 0 && o.body != null && o.body.length != 0) {
            this.body = new ProvaLiteral[o.body.length - o.offset];
            System.arraycopy(o.body, o.offset, this.body, 0, o.body.length - o.offset);
            return;
        }
        this.body = o.body;
    }

    private ProvaRuleImpl(ProvaRuleImpl o, boolean cloneVariables) {
        this.ruleId = o.ruleId;
        this.variables = cloneVariables ? o.cloneVariables() : o.getVariables();
        this.head = o.head;
        if (o.offset != 0 && o.body != null && o.body.length != 0) {
            this.body = new ProvaLiteral[o.body.length - o.offset];
            System.arraycopy(o.body, o.offset, this.body, 0, o.body.length - o.offset);
            return;
        }
        this.body = o.body;
        this.sourceCode = o.sourceCode;
        this.line = o.line;
        this.metadata = o.metadata;
    }

    public ProvaRuleImpl(long ruleId, ProvaLiteral head, ProvaLiteral[] body, List<ProvaVariable> variables) {
        this.ruleId = ruleId;
        int size = variables.size();
        for (ProvaVariable variable : variables) {
            this.variables.add(variable.clone(ruleId));
        }
        this.head = head;
        this.body = body;
    }

    @Override
    public void collectVariables() {
        if (this.head != null) {
            this.head.collectVariables(this.ruleId, this.variables);
        }
        if (this.body != null) {
            for (ProvaLiteral literal : this.body) {
                literal.collectVariables(this.ruleId, this.variables);
            }
        }
    }

    @Override
    public void collectVariables(int offset) {
        if (this.head != null) {
            this.head.collectVariables(this.ruleId, this.variables);
        }
        if (this.body != null) {
            for (int i = offset; i < this.body.length; ++i) {
                this.body[i].collectVariables(this.ruleId, this.variables);
            }
        }
    }

    @Override
    public void substituteVariables(ProvaVariablePtr[] varsMap) {
        if (this.head != null) {
            this.head.substituteVariables(varsMap);
        }
        if (this.body != null) {
            for (ProvaLiteral literal : this.body) {
                literal.substituteVariables(varsMap);
            }
        }
    }

    @Override
    public void setVariables(List<ProvaVariable> variables) {
        this.variables = variables;
    }

    @Override
    public List<ProvaVariable> getVariables() {
        return this.variables;
    }

    public void setHead(ProvaLiteral head) {
        if (head == null) {
            return;
        }
        this.head = head;
        ProvaObject[] fixed = head.getTerms().getFixed();
        if (fixed != null && fixed.length != 0) {
            this.firstArg = fixed[0] instanceof ProvaConstant ? ((ProvaConstant)fixed[0]).getObject() : "@";
        }
    }

    @Override
    public ProvaLiteral getHead() {
        return this.head;
    }

    public void setBody(ProvaLiteral[] body) {
        this.body = body;
    }

    @Override
    public ProvaLiteral[] getBody() {
        return this.body;
    }

    @Override
    public ProvaLiteral[] getGuardedBody(ProvaLiteral sourceLiteral) {
        if (sourceLiteral instanceof ProvaGuardedLiteralImpl) {
            List<ProvaLiteral> guard = sourceLiteral.getGuard();
            ProvaLiteral[] guardedBody = new ProvaLiteral[guard.size() + this.body.length];
            int index = 0;
            for (ProvaLiteral g : guard) {
                guardedBody[index++] = g;
            }
            System.arraycopy(this.body, 0, guardedBody, guard.size(), this.body.length);
            return guardedBody;
        }
        return this.body;
    }

    @Override
    public void setRuleId(long ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public long getRuleId() {
        return this.ruleId;
    }

    @Override
    public long getAbsRuleId() {
        return this.ruleId >= 0L ? this.ruleId : -this.ruleId;
    }

    @Override
    public ProvaRule cloneRule() {
        ProvaRuleImpl newRule = new ProvaRuleImpl(this);
        return newRule;
    }

    @Override
    public ProvaRule cloneRule(boolean cloneVariables) {
        if (this.variables.isEmpty()) {
            return this;
        }
        ProvaRuleImpl newRule = new ProvaRuleImpl(this, cloneVariables);
        return newRule;
    }

    @Override
    public List<ProvaVariable> cloneVariables() {
        int size = this.variables.size();
        ArrayList<ProvaVariable> newVariables = new ArrayList<ProvaVariable>(size);
        for (ProvaVariable variable : this.variables) {
            newVariables.add(variable.clone());
        }
        return newVariables;
    }

    @Override
    public boolean advance() {
        ++this.offset;
        return this.offset != this.body.length && this.body[this.offset].getTerms() == null;
    }

    @Override
    public ProvaLiteral getTop() {
        return this.offset < this.body.length ? this.body[this.offset] : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.head != null) {
            Map<String, List<Object>> metadata = this.head.getMetadata();
            if (metadata != null && !metadata.isEmpty()) {
                sb.append(metadata);
                sb.append(" ");
            }
            sb.append(this.head.cloneWithVariables(this.ruleId, this.variables));
        }
        if (this.body != null) {
            sb.append(":-");
            for (int i = this.offset; i < this.body.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                } else {
                    Map<String, List<Object>> metadata = this.body[i].getMetadata();
                    if (metadata != null && !metadata.isEmpty()) {
                        sb.append(metadata);
                        sb.append(" ");
                    }
                }
                sb.append(this.body[i].cloneWithVariables(this.ruleId, this.variables));
            }
        }
        return sb.toString();
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void addBodyLiteral(ProvaLiteral literal) {
        ProvaLiteral[] newBody = new ProvaLiteral[this.body.length + 1];
        System.arraycopy(this.body, 0, newBody, 0, this.body.length);
        newBody[this.body.length] = literal;
        this.body = newBody;
        this.collectVariables(this.offset);
    }

    @Override
    public void replaceTopBodyLiteral(List<ProvaLiteral> literals) {
        if (literals.size() == 1) {
            this.body[this.offset] = literals.get(0);
            return;
        }
        int size = literals.size() - 1;
        ProvaLiteral[] newBody = new ProvaLiteral[this.body.length + size - this.offset];
        newBody[0] = literals.get(0);
        System.arraycopy(this.body, this.offset + 1, newBody, 1 + size, this.body.length - this.offset - 1);
        for (int i = 1; i <= size; ++i) {
            newBody[i] = literals.get(i);
        }
        this.body = newBody;
        this.offset = 0;
    }

    @Override
    public Object getFirstArg() {
        return this.firstArg;
    }

    @Override
    public void removeAt(int index) {
        if (this.offset + index >= this.body.length) {
            return;
        }
        ProvaLiteral[] newBody = new ProvaLiteral[this.body.length - 1 - this.offset];
        System.arraycopy(this.body, this.offset + index + 1, newBody, index, this.body.length - 2 - this.offset);
        newBody[0] = this.body[0];
        this.body = newBody;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public void setRemoved() {
        this.removed = true;
    }

    @Override
    public boolean isCut() {
        if (this.cut == 0) {
            String symbol;
            this.cut = -1;
            if (this.body != null && this.body.length != 0 && (symbol = this.body[this.offset].getPredicate().getSymbol()).equals("cut")) {
                this.cut = 1;
            }
        }
        return this.cut > 0;
    }

    @Override
    public String getSourceCode() {
        if (log.isDebugEnabled() && this.sourceCode == null) {
            if (this.head != null && this.head.getPredicate().getSymbol().length() == 0) {
                return this.toString();
            }
            StringBuilder sb = new StringBuilder();
            if (this.head != null) {
                sb.append(this.head.getSourceCode());
            }
            sb.append(":-");
            if (this.body != null) {
                for (int i = this.offset; i < this.body.length; ++i) {
                    if (i != this.offset) {
                        sb.append(',');
                    }
                    sb.append(this.body[i].getSourceCode());
                }
            }
            sb.append('.');
            this.sourceCode = sb.toString();
        }
        return this.sourceCode;
    }

    @Override
    public void computeSourceCode() {
        if (log.isDebugEnabled()) {
            if (this.head != null) {
                this.head.setSourceCode(this.head.cloneWithVariables(this.variables).toString());
            }
            if (this.body == null) {
                return;
            }
            for (int i = this.offset; i < this.body.length; ++i) {
                this.body[i].setSourceCode(this.body[i].cloneWithVariables(this.variables).toString());
            }
        }
    }

    @Override
    public void setMetadata(String property, List<Object> value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, List<Object>>();
        }
        this.metadata.put(property, value);
    }

    @Override
    public void setSrc(List<Object> value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, List<Object>>();
        }
        this.metadata.put("src", value);
        String src = (String)value.get(0);
        ProvaPredicate predicate = this.head.getPredicate();
        predicate.getClauseSet().addRuleToSrc(this, src);
        predicate.getKnowledgeBase().addClauseSetToSrc(predicate.getClauseSet(), src);
    }

    @Override
    public List<Object> getMetadata(String property) {
        return this.metadata == null ? null : this.metadata.get(property);
    }

    @Override
    public void addMetadata(Map<String, List<Object>> m) {
        if (m == null) {
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, List<Object>>();
        }
        this.metadata.putAll(m);
    }

    @Override
    public Map<String, List<Object>> getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        return Collections.emptyMap();
    }

    @Override
    public void setLine(int line) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, List<Object>>();
        }
        this.metadata.put("line", Arrays.asList(Integer.toString(line)));
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }
}

