/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2;

import java.util.List;
import java.util.Map;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaListPtr;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaPredicate;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaMapImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.ProvaVariablePtrImpl;
import org.provarules.reference2.builtins.ProvaFailImpl;

public class ProvaUnificationImpl
implements ProvaUnification {
    private ProvaRule source;
    private ProvaRule target;
    private long sourceRuleId;
    private long targetRuleId;
    private List<ProvaVariable> sourceVariables;
    private List<ProvaVariable> targetVariables;
    private List<ProvaList> meta;

    public ProvaUnificationImpl(ProvaRule source, ProvaRule target) {
        this.init(source, target, true);
    }

    public ProvaUnificationImpl(ProvaRule source, ProvaRule target, boolean cloneTarget) {
        this.init(source, target, cloneTarget);
    }

    private void init(ProvaRule source, ProvaRule target, boolean cloneTarget) {
        this.source = source;
        this.target = target;
        this.sourceRuleId = source.getRuleId();
        this.targetRuleId = target.getRuleId();
        this.sourceVariables = source.getVariables();
        this.targetVariables = cloneTarget ? target.cloneVariables() : target.getVariables();
    }

    public void setSource(ProvaRule source) {
        this.source = source;
    }

    @Override
    public ProvaRule getSource() {
        return this.source;
    }

    public void setTarget(ProvaRule target) {
        this.target = target;
    }

    @Override
    public ProvaRule getTarget() {
        return this.target;
    }

    public void setSourceRuleId(long sourceRuleId) {
        this.sourceRuleId = sourceRuleId;
    }

    @Override
    public long getSourceRuleId() {
        return this.sourceRuleId;
    }

    public void setTargetRuleId(long targetRuleId) {
        this.targetRuleId = targetRuleId;
    }

    @Override
    public long getTargetRuleId() {
        return this.targetRuleId;
    }

    public void setSourceVariables(List<ProvaVariable> sourceVariables) {
        this.sourceVariables = sourceVariables;
    }

    @Override
    public List<ProvaVariable> getSourceVariables() {
        return this.sourceVariables;
    }

    public void setTargetVariables(List<ProvaVariable> targetVariables) {
        this.targetVariables = targetVariables;
    }

    @Override
    public List<ProvaVariable> getTargetVariables() {
        return this.targetVariables;
    }

    @Override
    public boolean unify() {
        ProvaPredicate targetPredicate;
        ProvaLiteral[] sourceLiterals = this.source.getBody();
        ProvaLiteral sourceLiteral = sourceLiterals[this.source.getOffset()];
        if (!this.matchMetadata(sourceLiteral, this.target)) {
            return false;
        }
        ProvaLiteral targetLiteral = this.target.getHead();
        ProvaPredicate sourcePredicate = sourceLiteral.getPredicate();
        return sourcePredicate.equals(targetPredicate = targetLiteral.getPredicate()) && sourceLiteral.unify(targetLiteral, this);
    }

    private boolean matchMetadata(ProvaLiteral sourceLiteral, ProvaRule target) {
        Map<String, List<Object>> sourceMetadata = sourceLiteral.getMetadata();
        if (sourceMetadata == null || sourceMetadata.size() == 0) {
            return true;
        }
        Map<String, List<Object>> targetMetadata = target.getMetadata();
        if (targetMetadata == null) {
            return false;
        }
        for (Map.Entry<String, List<Object>> s : sourceMetadata.entrySet()) {
            List<Object> value = targetMetadata.get(s.getKey());
            List<Object> sValue = s.getValue();
            if (value == null) {
                return false;
            }
            boolean matched = false;
            for (Object vo : value) {
                if (!(vo instanceof String)) continue;
                String v = (String)vo;
                for (Object sVo : sValue) {
                    if (!(sVo instanceof String)) continue;
                    String sV = (String)sVo;
                    if (sV.length() != 0 && Character.isUpperCase(sV.charAt(0))) {
                        if (this.meta == null) {
                            return false;
                        }
                        for (ProvaList m : this.meta) {
                            ProvaObject[] mo = m.getFixed();
                            String varName = (String)((ProvaConstant)mo[0]).getObject();
                            ProvaObject var = mo[1];
                            if (!varName.equals(sV)) continue;
                            if (mo[1] instanceof ProvaVariablePtr) {
                                ProvaVariablePtr varPtr = (ProvaVariablePtr)var;
                                var = this.sourceVariables.get(varPtr.getIndex()).getRecursivelyAssigned();
                            }
                            if (var instanceof ProvaVariable) {
                                ((ProvaVariable)var).setAssigned(ProvaConstantImpl.create(v));
                                matched = true;
                                break;
                            }
                            if (!(var instanceof ProvaConstant)) continue;
                            sV = (String)((ProvaConstant)var).getObject();
                            break;
                        }
                    }
                    if (matched) break;
                    if (!v.equals(sV)) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    @Override
    public ProvaLiteral[] rebuildNewGoals() {
        ProvaLiteral[] body = this.target.getBody();
        int bodyLength = body == null ? 0 : body.length;
        ProvaLiteral[] goals = new ProvaLiteralImpl[bodyLength];
        for (int i = 0; i < bodyLength; ++i) {
            goals[i] = body[i].rebuild(this);
        }
        return goals;
    }

    private ProvaLiteral[] rebuildNewGoals(ProvaDerivationNode node) {
        ProvaLiteral[] body;
        if (this.target.getBody() == null || this.target.getBody().length == 0) {
            return new ProvaLiteral[0];
        }
        boolean allGround = true;
        for (ProvaVariable var : this.targetVariables) {
            if (var.getRecursivelyAssigned().isGround()) continue;
            allGround = false;
            break;
        }
        int bodyLength = (body = this.target.getGuardedBody(this.source.getBody()[0])) == null ? 0 : body.length;
        ProvaLiteral[] goals = new ProvaLiteralImpl[bodyLength];
        for (int i = 0; i < bodyLength; ++i) {
            if ("cut".equals(body[i].getPredicate().getSymbol())) {
                ProvaVariablePtr any = (ProvaVariablePtr)body[i].getTerms().getFixed()[0];
                ProvaConstantImpl cutnode = ProvaConstantImpl.create(node);
                if (any.getRuleId() == this.source.getRuleId()) {
                    this.sourceVariables.get(any.getIndex()).setAssigned(cutnode);
                } else {
                    this.targetVariables.get(any.getIndex()).setAssigned(cutnode);
                }
                goals[i] = new ProvaLiteralImpl(body[i].getPredicate(), ProvaListImpl.create(new ProvaObject[]{cutnode}));
                continue;
            }
            goals[i] = body[i].rebuild(this);
            goals[i].setLine(body[i].getLine());
            if (!allGround) continue;
            goals[i].setGround(true);
        }
        return goals;
    }

    @Override
    public ProvaLiteral[] rebuildOldGoals(ProvaLiteral[] body) {
        if (!this.isSourceSubstituted()) {
            return body;
        }
        ProvaLiteral[] goals = new ProvaLiteralImpl[body.length];
        for (int i = 1; i < body.length; ++i) {
            goals[i] = body[i].rebuildSource(this);
        }
        return goals;
    }

    private ProvaLiteral[] rebuildOldGoals(ProvaLiteral[] body, int offset) {
        if (body[offset].isGround()) {
            return body;
        }
        ProvaLiteral[] goals = new ProvaLiteralImpl[body.length];
        for (int i = 1 + offset; i < body.length; ++i) {
            goals[i] = body[i].rebuildSource(this);
        }
        return goals;
    }

    private boolean isSourceSubstituted() {
        for (ProvaVariable variable : this.sourceVariables) {
            if (variable.getAssigned() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProvaVariable getVariableFromVariablePtr(ProvaVariablePtr variablePtr) {
        if (variablePtr.getRuleId() == this.sourceRuleId) {
            return this.sourceVariables.get(variablePtr.getIndex());
        }
        return this.targetVariables.get(variablePtr.getIndex());
    }

    @Override
    public ProvaObject rebuild(ProvaVariablePtr variablePtr) {
        ProvaVariable variable = this.getVariableFromVariablePtr(variablePtr);
        ProvaObject assigned = variable.getRecursivelyAssigned();
        if (assigned.getClass() == ProvaConstantImpl.class) {
            return assigned;
        }
        if (assigned instanceof ProvaVariable) {
            if (((ProvaVariable)assigned).getRuleId() == this.targetRuleId) {
                int index = assigned.collectVariables(this.targetRuleId, this.sourceVariables);
                return new ProvaVariablePtrImpl(this.sourceRuleId, index);
            }
            return new ProvaVariablePtrImpl(this.sourceRuleId, ((ProvaVariable)assigned).getIndex());
        }
        if (assigned instanceof ProvaList) {
            return ((ProvaList)assigned).rebuild(this);
        }
        if (assigned instanceof ProvaListPtr) {
            return ((ProvaListPtr)assigned).rebuild(this);
        }
        if (assigned instanceof ProvaMapImpl) {
            return ((ProvaMapImpl)assigned).rebuild(this);
        }
        return assigned;
    }

    @Override
    public ProvaObject rebuildSource(ProvaVariablePtr variablePtr) {
        ProvaVariable variable = this.getVariableFromVariablePtr(variablePtr);
        ProvaObject assigned = variable.getRecursivelyAssigned();
        if (assigned == variable && variablePtr.getRuleId() == this.sourceRuleId) {
            return variablePtr;
        }
        if (assigned.getClass() == ProvaConstantImpl.class) {
            return assigned;
        }
        if (assigned instanceof ProvaVariable) {
            if (((ProvaVariable)assigned).getRuleId() == this.targetRuleId) {
                int index = assigned.collectVariables(this.targetRuleId, this.sourceVariables);
                return new ProvaVariablePtrImpl(this.sourceRuleId, index);
            }
            return new ProvaVariablePtrImpl(this.sourceRuleId, ((ProvaVariable)assigned).getIndex());
        }
        if (assigned instanceof ProvaList) {
            return ((ProvaList)assigned).rebuildSource(this);
        }
        if (assigned instanceof ProvaListPtr) {
            return ((ProvaListPtr)assigned).rebuildSource(this);
        }
        if (assigned instanceof ProvaMapImpl) {
            return ((ProvaMapImpl)assigned).rebuildSource(this);
        }
        return assigned;
    }

    @Override
    public ProvaRule generateQuery(String symbol, ProvaKnowledgeBase kb, ProvaRule query, ProvaDerivationNode node) {
        ProvaRule newQuery;
        if (this.sourceVariables.isEmpty()) {
            return kb.generateGoal(this, node, this.target.getBody(), query.getBody(), query.getOffset(), this.targetVariables);
        }
        ProvaLiteral[] newGoals = this.rebuildNewGoals(node);
        if (newGoals.length != 0 && newGoals[newGoals.length - 1].getPredicate() instanceof ProvaFailImpl) {
            newQuery = new ProvaRuleImpl(0L, null, newGoals);
        } else {
            ProvaLiteral[] oldGoals = this.rebuildOldGoals(query.getBody(), query.getOffset());
            newQuery = kb.generateRule(null, newGoals, oldGoals, query.getOffset());
            if (oldGoals == query.getBody() && newQuery.getVariables().isEmpty()) {
                newQuery.setVariables(this.sourceVariables);
                return newQuery;
            }
        }
        return this.rebuild(newQuery);
    }

    private ProvaRule rebuild(ProvaRule newQuery) {
        int size = this.sourceVariables.size();
        if (size == 0) {
            return newQuery;
        }
        ProvaVariablePtr[] varsMap = new ProvaVariablePtr[size];
        List<ProvaVariable> newVariables = newQuery.getVariables();
        int index = 0;
        for (int i = 0; i < size; ++i) {
            if (this.sourceVariables.get(i).getAssigned() != null) continue;
            varsMap[i] = new ProvaVariablePtrImpl(0L, index);
            ProvaVariable newVariable = this.sourceVariables.get(i);
            newVariable.setIndex(index++);
            newVariable.setRuleId(0L);
            newVariables.add(newVariable);
        }
        newQuery.substituteVariables(varsMap);
        return newQuery;
    }

    @Override
    public boolean targetUnchanged() {
        for (ProvaVariable var : this.targetVariables) {
            if (var.getAssigned() == null || var.getAssigned() instanceof ProvaVariable && var.getType() == ((ProvaVariable)var.getAssigned()).getType()) continue;
            return false;
        }
        return true;
    }

    public void setMeta(List<ProvaList> meta) {
        if (meta != null) {
            this.meta = meta;
        }
    }
}

