/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.ProvaVariableImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaAtImpl
extends ProvaBuiltinImpl {
    public ProvaAtImpl(ProvaKnowledgeBase kb) {
        super(kb, "at");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaObject olist;
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 2) {
            return false;
        }
        ProvaObject lt = data[0];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr ltPtr = (ProvaVariablePtr)lt;
            lt = variables.get(ltPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(lt instanceof ProvaList)) {
            return false;
        }
        ProvaList args = (ProvaList)lt;
        if (args.getFixed().length != 2) {
            return false;
        }
        ProvaObject ppos = args.getFixed()[1];
        if (ppos instanceof ProvaVariablePtr) {
            ProvaVariablePtr pposPtr = (ProvaVariablePtr)ppos;
            ppos = variables.get(pposPtr.getIndex()).getRecursivelyAssigned();
        }
        if (!(ppos instanceof ProvaConstant)) {
            return false;
        }
        Object opos = ((ProvaConstant)ppos).getObject();
        if (!(opos instanceof Integer)) {
            return false;
        }
        int pos = (Integer)opos;
        if (pos < -1) {
            return false;
        }
        ProvaObject out = data[1];
        if (out instanceof ProvaVariablePtr) {
            ProvaVariablePtr outPtr = (ProvaVariablePtr)out;
            out = variables.get(outPtr.getIndex()).getRecursivelyAssigned();
        }
        if ((olist = args.getFixed()[0]) instanceof ProvaVariablePtr) {
            ProvaVariablePtr listPtr = (ProvaVariablePtr)olist;
            olist = variables.get(listPtr.getIndex()).getRecursivelyAssigned();
        }
        if (olist instanceof ProvaVariable) {
            if (pos < 0) {
                return false;
            }
            ProvaObject[] fixed = new ProvaObject[pos + 1];
            for (int i = 0; i < pos; ++i) {
                fixed[i] = ProvaVariableImpl.create();
            }
            fixed[pos] = out;
            ProvaList newList = ProvaListImpl.create(fixed, ProvaVariableImpl.create());
            ((ProvaVariable)olist).setAssigned(newList);
            return true;
        }
        if (!(olist instanceof ProvaList)) {
            return false;
        }
        ProvaList list = (ProvaList)olist;
        if (pos == -1) {
            if (list.getTail() != null) {
                return false;
            }
            pos = list.getFixed().length - 1;
        } else if (list.getFixed().length - 1 < pos) {
            return false;
        }
        ProvaObject element = list.getFixed()[pos].cloneWithVariables(variables);
        if (out instanceof ProvaVariable) {
            ((ProvaVariable)out).setAssigned(element);
            return true;
        }
        if (out instanceof ProvaConstant || out instanceof ProvaList) {
            ProvaPredicateImpl pred = new ProvaPredicateImpl("", 1, this.kb);
            ProvaList ls = ProvaListImpl.create(new ProvaObject[]{element});
            ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ls);
            ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
            pred.addClause(clause);
            ProvaList outls = ProvaListImpl.create(new ProvaObject[]{out});
            ProvaLiteralImpl newLiteral = new ProvaLiteralImpl(pred, outls);
            newLiterals.add(newLiteral);
            return true;
        }
        return false;
    }
}

