/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;

public class ProvaCopyImpl
extends ProvaBuiltinImpl {
    private static final int sChunk = 8192;

    public ProvaCopyImpl(ProvaKnowledgeBase kb) {
        super(kb, "copy");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaObject out;
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        ProvaObject in = data[0];
        if (in instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)in;
            in = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        if ((out = data[1]) instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)out;
            out = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        Reader is = (Reader)((ProvaConstant)in).getObject();
        Writer os = (Writer)((ProvaConstant)out).getObject();
        this.runWithExceptions(is, os);
        return true;
    }

    private void process(Reader is, Writer os) throws IOException {
        int length;
        char[] buffer = new char[8192];
        while ((length = is.read(buffer, 0, 8192)) != -1) {
            os.write(buffer, 0, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithExceptions(Reader is, Writer os) {
        block21: {
            IOException processException = null;
            try {
                this.process(is, os);
            }
            catch (IOException e) {
                processException = e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (processException != null) {
                            throw new RuntimeException(processException);
                        }
                        throw new RuntimeException(e);
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        if (processException != null) {
                            throw new RuntimeException(processException);
                        }
                        throw new RuntimeException(e);
                    }
                }
                if (processException == null) break block21;
                throw new RuntimeException(processException);
            }
        }
    }
}

