/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.builtins;

import java.util.List;
import org.provarules.agent2.ProvaReagent;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaDerivationNode;
import org.provarules.kernel2.ProvaGoal;
import org.provarules.kernel2.ProvaKnowledgeBase;
import org.provarules.kernel2.ProvaList;
import org.provarules.kernel2.ProvaLiteral;
import org.provarules.kernel2.ProvaObject;
import org.provarules.kernel2.ProvaRule;
import org.provarules.kernel2.ProvaRuleSet;
import org.provarules.kernel2.ProvaUnification;
import org.provarules.kernel2.ProvaVariable;
import org.provarules.kernel2.ProvaVariablePtr;
import org.provarules.reference2.ProvaConstantImpl;
import org.provarules.reference2.ProvaGoalImpl;
import org.provarules.reference2.ProvaListImpl;
import org.provarules.reference2.ProvaLiteralImpl;
import org.provarules.reference2.ProvaPredicateImpl;
import org.provarules.reference2.ProvaRuleImpl;
import org.provarules.reference2.builtins.ProvaBuiltinImpl;
import org.provarules.reference2.builtins.target.ProvaTarget;
import org.provarules.reference2.builtins.target.ProvaTargetImpl;

public class ProvaMatchImpl
extends ProvaBuiltinImpl {
    private ProvaLiteral targetLiteral;
    private ProvaRule targetQuery;

    public ProvaMatchImpl(ProvaKnowledgeBase kb) {
        super(kb, "match");
    }

    @Override
    public boolean process(ProvaReagent prova, ProvaDerivationNode node, ProvaGoal goal, List<ProvaLiteral> newLiterals, ProvaRule query) {
        ProvaLiteral literal = goal.getGoal();
        List<ProvaVariable> variables = query.getVariables();
        ProvaList terms = literal.getTerms();
        ProvaObject[] data = terms.getFixed();
        if (data.length != 3) {
            return false;
        }
        ProvaObject handle = data[2];
        if (handle instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)handle;
            handle = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        ProvaObject[] target = ((ProvaList)data[0]).getFixed();
        String symbol = ((ProvaConstant)target[0]).getObject().toString();
        ProvaRuleSet clauses = this.kb.getPredicates(symbol, target.length - 1);
        ProvaGoal targetGoal = null;
        ProvaTarget ptr = null;
        if (handle instanceof ProvaVariable) {
            this.targetLiteral = this.kb.generateLiteral(target);
            this.targetQuery = this.kb.generateGoal(new ProvaLiteral[]{this.targetLiteral}, variables);
            targetGoal = new ProvaGoalImpl(this.targetQuery);
            ptr = ProvaTargetImpl.create(targetGoal);
            ((ProvaVariable)handle).setAssigned(ProvaConstantImpl.create(ptr));
        } else if (handle instanceof ProvaConstant) {
            ptr = (ProvaTarget)((ProvaConstant)handle).getObject();
            targetGoal = ptr.getTarget();
        }
        ProvaUnification unification = clauses.nextMatch(this.kb, targetGoal);
        if (unification == null) {
            return false;
        }
        ProvaRule candidate = unification.getTarget();
        ptr.setCandidate(candidate);
        ProvaObject lt = data[1];
        if (lt instanceof ProvaVariablePtr) {
            ProvaVariablePtr varPtr = (ProvaVariablePtr)lt;
            lt = variables.get(varPtr.getIndex()).getRecursivelyAssigned();
        }
        ProvaLiteral l = (ProvaLiteral)candidate.getHead().cloneWithVariables(variables);
        ProvaObject[] arr = l.getTerms().getFixed();
        ProvaObject[] newArr = new ProvaObject[1 + arr.length];
        System.arraycopy(arr, 0, newArr, 1, arr.length);
        newArr[0] = ProvaConstantImpl.create(l.getPredicate().getSymbol());
        if (lt instanceof ProvaVariable) {
            ((ProvaVariable)lt).setAssigned(ProvaListImpl.create(newArr));
            return true;
        }
        if (!(lt instanceof ProvaList)) {
            return false;
        }
        ProvaPredicateImpl pred = new ProvaPredicateImpl("", 1, this.kb);
        ProvaLiteralImpl lit = new ProvaLiteralImpl(pred, ProvaListImpl.create(newArr));
        ProvaRule clause = ProvaRuleImpl.createVirtualRule(1L, lit, null);
        pred.addClause(clause);
        ProvaLiteralImpl newLiteral = new ProvaLiteralImpl(pred, (ProvaList)lt.cloneWithVariables(variables));
        newLiterals.add(newLiteral);
        return true;
    }
}

