/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.messaging.where;

import java.util.Map;
import org.provarules.reference2.messaging.where.WhereNode;

public class WhereBinaryOperation
implements WhereNode {
    private final WhereNode left;
    private final WhereNode right;
    private final Operator operator;

    public WhereBinaryOperation(WhereNode left, WhereNode right, Operator operator) {
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public boolean evaluate(Map<Object, Object> vars, Map<Object, Object> vars2) {
        switch (this.operator) {
            case And: {
                return this.left.evaluate(vars, vars2) && this.right.evaluate(vars, vars2);
            }
            case Or: {
                return this.left.evaluate(vars, vars2) || this.right.evaluate(vars, vars2);
            }
            case Xor: {
                return this.left.evaluate(vars, vars2) ^ this.right.evaluate(vars, vars2);
            }
        }
        return false;
    }

    public String toString() {
        return "(" + this.left.toString() + " " + this.operator.toString() + " " + this.right.toString() + ")";
    }

    public static enum Operator {
        And,
        Or,
        Xor;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

