/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.reference2.operators;

import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaObject;
import org.provarules.reference2.operators.ProvaAddImpl;
import org.provarules.reference2.operators.ProvaDivideImpl;
import org.provarules.reference2.operators.ProvaFcalcImpl;
import org.provarules.reference2.operators.ProvaMultiplyImpl;
import org.provarules.reference2.operators.ProvaNegateImpl;
import org.provarules.reference2.operators.ProvaOperator;
import org.provarules.reference2.operators.ProvaRemainderImpl;
import org.provarules.reference2.operators.ProvaSubtractImpl;

public class ProvaOperatorFactoryImpl {
    public static ProvaOperator create(String op) {
        if ("+".equals(op)) {
            return new ProvaAddImpl();
        }
        if ("-".equals(op)) {
            return new ProvaSubtractImpl();
        }
        if ("*".equals(op)) {
            return new ProvaMultiplyImpl();
        }
        if ("/".equals(op)) {
            return new ProvaDivideImpl();
        }
        if ("mod".equals(op)) {
            return new ProvaRemainderImpl();
        }
        if ("neg".equals(op)) {
            return new ProvaNegateImpl();
        }
        throw new RuntimeException("Invalid operator " + op);
    }

    public static ProvaOperator createFunctionCall(ProvaObject otype, ProvaObject omethod) {
        String type = ((ProvaConstant)otype).getObject().toString();
        String method = ((ProvaConstant)omethod).getObject().toString();
        return new ProvaFcalcImpl(type, method);
    }
}

