/*
 * Decompiled with CFR 0.152.
 */
package org.provarules.service.impl;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.provarules.api2.ProvaCommunicator;
import org.provarules.api2.ProvaCommunicatorImpl;
import org.provarules.exchange.ProvaSolution;
import org.provarules.kernel2.ProvaConstant;
import org.provarules.kernel2.ProvaList;
import org.provarules.service.EPService;
import org.provarules.service.ProvaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvaServiceImpl
implements ProvaService {
    private static final Logger log = LoggerFactory.getLogger((String)"service");
    private String id;
    private ConcurrentMap<String, ProvaCommunicator> engines;
    private ConcurrentMap<String, List<String>> topicDestinations = new ConcurrentHashMap<String, List<String>>();
    private ConcurrentMap<String, EPService> callbacks = new ConcurrentHashMap<String, EPService>();

    @Override
    public void init() {
        this.id = UUID.randomUUID().toString();
        this.engines = new ConcurrentHashMap<String, ProvaCommunicator>();
        System.out.println("Prova Service " + this.id + " created");
    }

    @Override
    public void destroy() {
        if (this.engines != null) {
            for (ProvaCommunicator engine : this.engines.values()) {
                engine.shutdown();
            }
        }
        System.out.println("Prova Service " + this.id + " destroyed");
    }

    @Override
    public String instance(String agent, String rulebase) {
        try {
            HashMap<String, Object> globals = new HashMap<String, Object>();
            ProvaCommunicatorImpl prova = new ProvaCommunicatorImpl(this, agent, null, rulebase, false, globals);
            this.engines.put(agent, prova);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return agent;
    }

    @Override
    public String instance(String agent, String rulebase, PrintWriter out) {
        try {
            HashMap<String, Object> globals = new HashMap<String, Object>();
            ProvaCommunicatorImpl prova = new ProvaCommunicatorImpl(this, agent, null, rulebase, false, globals);
            prova.setPrintWriter(out);
            this.engines.put(agent, prova);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return agent;
    }

    @Override
    public void release(String agent) {
        ProvaCommunicator engine = (ProvaCommunicator)this.engines.remove(agent);
        if (engine == null) {
            throw new RuntimeException("No engine instance " + agent);
        }
        engine.stop();
    }

    @Override
    public List<ProvaSolution[]> consult(String agent, String src, String key) {
        try {
            ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(agent);
            if (engine == null) {
                throw new RuntimeException("No engine instance " + agent);
            }
            return engine.consultSync(src, key, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ProvaSolution[]> consult(String agent, BufferedReader in, String key) {
        try {
            ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(agent);
            if (engine == null) {
                throw new RuntimeException("No engine instance " + agent);
            }
            return engine.consultSync(in, key, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void send(String dest, ProvaList terms) {
        String topic;
        Object verb = ((ProvaConstant)terms.getFixed()[3]).getObject();
        if ("present".equals(verb)) {
            topic = ((ProvaList)terms.getFixed()[4]).getFixed()[0].toString();
            if (log.isDebugEnabled()) {
                log.debug("Subscriber " + dest + " to receive stream on " + topic);
            }
            this.registerMapping(topic, dest);
        } else {
            if ("data".equals(verb)) {
                if (log.isDebugEnabled()) {
                    log.debug("Dispatch data on stream " + dest);
                }
                for (String target : (List)this.topicDestinations.get(dest)) {
                    ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(target);
                    if (engine == null) {
                        log.error("Subscriber " + target + " not present");
                    }
                    engine.addMsg(terms);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Sent: " + terms + " to " + target);
                }
                return;
            }
            if ("unregister".equals(verb)) {
                topic = ((ProvaList)terms.getFixed()[4]).getFixed()[0].toString();
                this.unregisterMapping(topic, dest);
            }
        }
        ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(dest);
        if (engine == null) {
            throw new RuntimeException("No engine instance " + dest);
        }
        engine.addMsg(terms);
        if (log.isDebugEnabled()) {
            log.debug("Sent: " + terms + " to " + dest);
        }
    }

    private synchronized void registerMapping(String topic, String dest) {
        List list = this.topicDestinations.computeIfAbsent(topic, k -> new ArrayList());
        list.add(dest);
    }

    private synchronized void unregisterMapping(String topic, String dest) {
        List list = (List)this.topicDestinations.get(topic);
        if (list == null) {
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!dest.equals(iter.next())) continue;
            iter.remove();
            return;
        }
    }

    @Override
    public void setGlobalConstant(String agent, String name, Object value) {
        ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(agent);
        if (engine == null) {
            throw new RuntimeException("No engine instance " + agent);
        }
        engine.setGlobalConstant(name, value);
    }

    @Override
    public void send(String xid, String dest, String agent, String verb, Object content) {
        EPService callback = (EPService)this.callbacks.get(dest);
        if (callback != null && callback != this) {
            if (!(content instanceof Map)) {
                throw new IllegalArgumentException();
            }
            Map payload = (Map)content;
            if ("present".equals(verb)) {
                String topic = payload.get("topic").toString();
                if (log.isDebugEnabled()) {
                    log.debug("Subscriber " + dest + " to receive stream on " + topic);
                }
                this.registerMapping(topic, dest);
            }
            callback.send(xid, dest, agent, verb, payload, this);
        } else {
            this.send(xid, dest, agent, verb, content, this);
        }
    }

    @Override
    public void send(String xid, String dest, String agent, String verb, Object content, EPService callback) {
        if (callback != this) {
            this.callbacks.putIfAbsent(agent, callback);
        }
        if ("present".equals(verb)) {
            String topic;
            if (content instanceof ProvaList) {
                topic = ((ProvaConstant)((ProvaList)content).getFixed()[0]).getObject().toString();
            } else {
                Map payload = (Map)content;
                topic = payload.get("topic").toString();
            }
            if (log.isDebugEnabled()) {
                log.debug("Subscriber " + dest + " to receive stream on " + topic);
            }
            this.registerMapping(topic, dest);
        } else {
            if ("data".equals(verb)) {
                if (log.isDebugEnabled()) {
                    log.debug("Dispatch data on stream " + dest);
                }
                for (String target : (List)this.topicDestinations.get(dest)) {
                    ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(target);
                    if (engine == null) {
                        log.error("Subscriber " + target + " not present");
                        continue;
                    }
                    engine.addMsg(xid, agent, verb, content);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Sent: " + content + " to " + target);
                }
                return;
            }
            if ("unregister".equals(verb)) {
                Map payload = (Map)content;
                String topic = payload.get("topic").toString();
                this.unregisterMapping(topic, dest);
            }
        }
        ProvaCommunicator engine = (ProvaCommunicator)this.engines.get(dest);
        if (engine == null) {
            throw new RuntimeException("No engine instance " + dest);
        }
        engine.addMsg(xid, agent, verb, content);
        if (log.isDebugEnabled()) {
            log.debug("Sent: " + content + " to " + dest);
        }
    }

    @Override
    public void register(String agent, EPService epService) {
        this.callbacks.putIfAbsent(agent, epService);
    }
}

