/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.RDF4JConfigException;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.http.client.BackgroundResultExecutor;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParser;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.helpers.QueryResultCollector;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.ParseErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLProtocolSession
implements HttpClientDependent,
AutoCloseable {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;
    public static final int DEFAULT_MAXIMUM_URL_LENGTH = 4083;
    @Deprecated
    public static final int MAXIMUM_URL_LENGTH = 4083;
    public static final String MAXIMUM_URL_LENGTH_PARAM = "rdf4j.sparql.url.maxlength";
    private final int maximumUrlLength;
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ValueFactory valueFactory;
    private String queryURL;
    private String updateURL;
    private HttpClient httpClient;
    private final BackgroundResultExecutor background;
    private final HttpClientContext httpContext;
    private HttpParams params;
    private ParserConfig parserConfig = new ParserConfig();
    private TupleQueryResultFormat preferredTQRFormat = TupleQueryResultFormat.SPARQL;
    private BooleanQueryResultFormat preferredBQRFormat = BooleanQueryResultFormat.TEXT;
    private RDFFormat preferredRDFFormat = RDFFormat.TURTLE;
    private Map<String, String> additionalHttpHeaders = Collections.emptyMap();

    public SPARQLProtocolSession(HttpClient client, ExecutorService executor) {
        this.httpClient = client;
        this.httpContext = new HttpClientContext();
        this.background = new BackgroundResultExecutor(executor);
        this.valueFactory = SimpleValueFactory.getInstance();
        this.httpContext.setCookieStore((CookieStore)new BasicCookieStore());
        this.parserConfig.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        this.parserConfig.addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        int maximumUrlLength = 4083;
        String propertyValue = System.getProperty(MAXIMUM_URL_LENGTH_PARAM);
        if (propertyValue != null) {
            try {
                maximumUrlLength = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException e) {
                throw new RDF4JConfigException("integer value expected for property rdf4j.sparql.url.maxlength", e);
            }
        }
        this.maximumUrlLength = maximumUrlLength;
    }

    @Override
    public final HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    protected void setQueryURL(String queryURL) {
        if (queryURL == null) {
            throw new IllegalArgumentException("queryURL must not be null");
        }
        this.queryURL = queryURL;
    }

    protected void setUpdateURL(String updateURL) {
        if (updateURL == null) {
            throw new IllegalArgumentException("updateURL must not be null");
        }
        this.updateURL = updateURL;
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.preferredTQRFormat = format;
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.preferredTQRFormat;
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.preferredRDFFormat = format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.preferredRDFFormat;
    }

    public void setPreferredBooleanQueryResultFormat(BooleanQueryResultFormat format) {
        this.preferredBQRFormat = format;
    }

    public BooleanQueryResultFormat getPreferredBooleanQueryResultFormat() {
        return this.preferredBQRFormat;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.setUsernameAndPasswordForUrl(username, password, this.getQueryURL());
    }

    protected void setUsernameAndPasswordForUrl(String username, String password, String url) {
        if (username != null && password != null) {
            this.logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)url);
            URI requestURI = URI.create(url);
            String host = requestURI.getHost();
            int port = requestURI.getPort();
            AuthScope scope = new AuthScope(host, port);
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(scope, (Credentials)cred);
            this.httpContext.setCredentialsProvider((CredentialsProvider)credsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            HttpHost httpHost = new HttpHost(requestURI.getHost(), requestURI.getPort(), requestURI.getScheme());
            authCache.put(httpHost, (AuthScheme)basicAuth);
            this.httpContext.setAuthCache((AuthCache)authCache);
        } else {
            this.httpContext.removeAttribute("http.auth.auth-cache");
            this.httpContext.removeAttribute("http.auth.credentials-provider");
        }
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    @Override
    public void close() {
        this.background.close();
    }

    public TupleQueryResult sendTupleQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        return this.sendTupleQuery(ql, query, null, dataset, includeInferred, 0, bindings);
    }

    public TupleQueryResult sendTupleQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpUriRequest method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        return this.getBackgroundTupleQueryResult(method);
    }

    public void sendTupleQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, TupleQueryResultHandler handler, Binding ... bindings) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpUriRequest method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        this.getTupleQueryResult(method, handler);
    }

    public void sendUpdate(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        this.sendUpdate(ql, update, baseURI, dataset, includeInferred, 0, bindings);
    }

    public void sendUpdate(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpUriRequest method = this.getUpdateMethod(ql, update, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        try {
            this.executeNoContent(method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (MalformedQueryException e) {
            throw e;
        }
        catch (QueryInterruptedException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    public GraphQueryResult sendGraphQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        return this.sendGraphQuery(ql, query, null, dataset, includeInferred, 0, bindings);
    }

    public GraphQueryResult sendGraphQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        try {
            HttpUriRequest method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
            return this.getRDFBackground(method, false);
        }
        catch (RDFHandlerException e) {
            throw new RepositoryException(e);
        }
    }

    public void sendGraphQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, RDFHandler handler, Binding ... bindings) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        this.sendGraphQuery(ql, query, null, dataset, includeInferred, 0, handler, bindings);
    }

    public void sendGraphQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, RDFHandler handler, Binding ... bindings) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpUriRequest method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        this.getRDF(method, handler, false);
    }

    public boolean sendBooleanQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        return this.sendBooleanQuery(ql, query, null, dataset, includeInferred, 0, bindings);
    }

    public boolean sendBooleanQuery(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        HttpUriRequest method = this.getQueryMethod(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        try {
            return this.getBoolean(method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (MalformedQueryException e) {
            throw e;
        }
        catch (QueryInterruptedException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return Collections.unmodifiableMap(this.additionalHttpHeaders);
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders == null ? Collections.emptyMap() : additionalHttpHeaders;
    }

    protected HttpUriRequest getQueryMethod(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        HttpGet method;
        String queryUrlWithParams;
        List<NameValuePair> queryParams = this.getQueryMethodParameters(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        try {
            URIBuilder urib = new URIBuilder(this.getQueryURL());
            for (NameValuePair nvp : queryParams) {
                urib.addParameter(nvp.getName(), nvp.getValue());
            }
            queryUrlWithParams = urib.toString();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (this.shouldUsePost(queryUrlWithParams)) {
            HttpPost postMethod = new HttpPost(this.getQueryURL());
            postMethod.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(queryParams, UTF8));
            method = postMethod;
        } else {
            method = new HttpGet(queryUrlWithParams);
        }
        for (Map.Entry<String, String> additionalHeader : this.additionalHttpHeaders.entrySet()) {
            method.addHeader(additionalHeader.getKey(), additionalHeader.getValue());
        }
        return method;
    }

    protected boolean shouldUsePost(String fullQueryUrl) {
        return fullQueryUrl.length() > this.maximumUrlLength;
    }

    protected HttpUriRequest getUpdateMethod(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        return this.getUpdateMethod(ql, update, baseURI, dataset, includeInferred, 0, bindings);
    }

    protected HttpUriRequest getUpdateMethod(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        HttpPost method = new HttpPost(this.getUpdateURL());
        method.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        List<NameValuePair> queryParams = this.getUpdateMethodParameters(ql, update, baseURI, dataset, includeInferred, maxQueryTime, bindings);
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(queryParams, UTF8));
        if (this.additionalHttpHeaders != null) {
            for (Map.Entry<String, String> additionalHeader : this.additionalHttpHeaders.entrySet()) {
                method.addHeader(additionalHeader.getKey(), additionalHeader.getValue());
            }
        }
        return method;
    }

    protected List<NameValuePair> getQueryMethodParameters(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
        if (query != null) {
            if (baseURI != null && !baseURI.equals("")) {
                query = "BASE <" + baseURI + "> \n" + query;
            }
            queryParams.add((NameValuePair)new BasicNameValuePair("query", query));
        }
        if (dataset != null) {
            for (IRI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("default-graph-uri", String.valueOf(defaultGraphURI)));
            }
            for (IRI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("named-graph-uri", String.valueOf(namedGraphURI)));
            }
        }
        return queryParams;
    }

    protected List<NameValuePair> getUpdateMethodParameters(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        return this.getUpdateMethodParameters(ql, update, baseURI, dataset, includeInferred, 0, bindings);
    }

    protected List<NameValuePair> getUpdateMethodParameters(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
        if (update != null) {
            if (baseURI != null && !baseURI.equals("")) {
                update = "BASE <" + baseURI + "> \n" + update;
            }
            queryParams.add((NameValuePair)new BasicNameValuePair("update", update));
            this.logger.debug("added update string {}", (Object)update);
        }
        if (dataset != null) {
            if (dataset.getDefaultRemoveGraphs().size() > 0) {
                if (!dataset.getDefaultRemoveGraphs().equals(dataset.getDefaultGraphs())) {
                    this.logger.warn("ambiguous dataset spec for SPARQL endpoint: default graphs and default remove graphs both defined but not equal");
                }
                for (IRI graphURI : dataset.getDefaultRemoveGraphs()) {
                    if (dataset.getDefaultInsertGraph() != null && !dataset.getDefaultInsertGraph().equals(graphURI)) {
                        this.logger.warn("ambiguous dataset spec for SPARQL endpoint: default insert graph ({}) and default remove graph ({}) both defined but not equal. ", (Object)dataset.getDefaultInsertGraph(), (Object)graphURI);
                    }
                    queryParams.add((NameValuePair)new BasicNameValuePair("using-graph-uri", String.valueOf(graphURI)));
                }
            }
            if (dataset.getDefaultInsertGraph() != null) {
                if (!(dataset.getDefaultGraphs().isEmpty() || dataset.getDefaultGraphs().size() == 1 && dataset.getDefaultGraphs().contains(dataset.getDefaultInsertGraph()))) {
                    this.logger.warn("ambiguous dataset spec for SPARQL endpoint: default insert graph ({}) and default graphs both defined but not equal. ", (Object)dataset.getDefaultInsertGraph());
                }
                queryParams.add((NameValuePair)new BasicNameValuePair("using-graph-uri", String.valueOf(dataset.getDefaultInsertGraph())));
            }
            for (IRI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("using-graph-uri", String.valueOf(defaultGraphURI)));
            }
            for (IRI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add((NameValuePair)new BasicNameValuePair("using-named-graph-uri", String.valueOf(namedGraphURI)));
            }
        }
        return queryParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleQueryResult getBackgroundTupleQueryResult(HttpUriRequest method) throws RepositoryException, QueryInterruptedException, MalformedQueryException, IOException {
        boolean submitted = false;
        Set<QueryResultFormat> tqrFormats = TupleQueryResultParserRegistry.getInstance().getKeys();
        if (tqrFormats.isEmpty()) {
            throw new RepositoryException("No tuple query result parsers have been registered");
        }
        TupleQueryResult tRes = null;
        HttpResponse response = this.sendTupleQueryViaHttp(method, tqrFormats);
        try {
            String mimeType = this.getResponseMIMEType(response);
            QueryResultFormat format = TupleQueryResultFormat.matchMIMEType(mimeType, tqrFormats).orElseThrow(() -> new RepositoryException("Server responded with an unsupported file format: " + mimeType));
            TupleQueryResultParser parser = QueryResultIO.createTupleParser(format, this.getValueFactory());
            tRes = this.background.parse(parser, response.getEntity().getContent());
            submitted = true;
            TupleQueryResult tupleQueryResult = tRes;
            return tupleQueryResult;
        }
        finally {
            if (!submitted) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTupleQueryResult(HttpUriRequest method, TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        Set<QueryResultFormat> tqrFormats = TupleQueryResultParserRegistry.getInstance().getKeys();
        if (tqrFormats.isEmpty()) {
            throw new RepositoryException("No tuple query result parsers have been registered");
        }
        HttpResponse response = this.sendTupleQueryViaHttp(method, tqrFormats);
        try {
            String mimeType = this.getResponseMIMEType(response);
            try {
                QueryResultFormat format = TupleQueryResultFormat.matchMIMEType(mimeType, tqrFormats).orElseThrow(() -> new RepositoryException("Server responded with an unsupported file format: " + mimeType));
                TupleQueryResultParser parser = QueryResultIO.createTupleParser(format, this.getValueFactory());
                parser.setQueryResultHandler(handler);
                parser.parseQueryResult(response.getEntity().getContent());
            }
            catch (QueryResultParseException e) {
                throw new RepositoryException("Malformed query result from server", e);
            }
            catch (QueryResultHandlerException e) {
                if (e instanceof TupleQueryResultHandlerException) {
                    throw (TupleQueryResultHandlerException)e;
                }
                throw new TupleQueryResultHandlerException(e);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private HttpResponse sendTupleQueryViaHttp(HttpUriRequest method, Set<QueryResultFormat> tqrFormats) throws RepositoryException, IOException, QueryInterruptedException, MalformedQueryException {
        ArrayList<String> acceptValues = new ArrayList<String>(tqrFormats.size());
        for (QueryResultFormat format : tqrFormats) {
            int qValue = 10;
            if (this.preferredTQRFormat != null && !this.preferredTQRFormat.equals(format)) {
                qValue -= 2;
            }
            Iterator<String> iterator = format.getMIMETypes().iterator();
            while (iterator.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = iterator.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                acceptValues.add(acceptParam);
            }
        }
        method.addHeader("Accept", String.join((CharSequence)", ", acceptValues));
        try {
            return this.executeOK(method);
        }
        catch (MalformedQueryException | QueryInterruptedException | RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphQueryResult getRDFBackground(HttpUriRequest method, boolean requireContext) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        boolean submitted = false;
        Set<RDFFormat> rdfFormats = RDFParserRegistry.getInstance().getKeys();
        if (rdfFormats.isEmpty()) {
            throw new RepositoryException("No tuple RDF parsers have been registered");
        }
        GraphQueryResult gRes = null;
        HttpResponse response = this.sendGraphQueryViaHttp(method, requireContext, rdfFormats);
        try {
            String mimeType = this.getResponseMIMEType(response);
            RDFFormat format = RDFFormat.matchMIMEType(mimeType, rdfFormats).orElseThrow(() -> new RepositoryException("Server responded with an unsupported file format: " + mimeType));
            RDFParser parser = Rio.createParser(format, this.getValueFactory());
            parser.setParserConfig(this.getParserConfig());
            parser.setParseErrorListener(new ParseErrorLogger());
            Charset charset = null;
            HttpEntity entity = response.getEntity();
            if (format.hasCharset() && entity != null && entity.getContentType() != null) {
                try {
                    charset = ContentType.parse((String)entity.getContentType().getValue()).getCharset();
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
                if (charset == null) {
                    charset = UTF8;
                }
            }
            if (entity == null) {
                throw new RepositoryException("Server response was empty.");
            }
            String baseURI = method.getURI().toASCIIString();
            gRes = this.background.parse(parser, entity.getContent(), charset, baseURI);
            submitted = true;
            GraphQueryResult graphQueryResult = gRes;
            return graphQueryResult;
        }
        finally {
            if (!submitted) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getRDF(HttpUriRequest method, RDFHandler handler, boolean requireContext) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException, QueryInterruptedException {
        Set<RDFFormat> rdfFormats = RDFParserRegistry.getInstance().getKeys();
        if (rdfFormats.isEmpty()) {
            throw new RepositoryException("No tuple RDF parsers have been registered");
        }
        HttpResponse response = this.sendGraphQueryViaHttp(method, requireContext, rdfFormats);
        try {
            String mimeType = this.getResponseMIMEType(response);
            try {
                RDFFormat format = RDFFormat.matchMIMEType(mimeType, rdfFormats).orElseThrow(() -> new RepositoryException("Server responded with an unsupported file format: " + mimeType));
                RDFParser parser = Rio.createParser(format, this.getValueFactory());
                parser.setParserConfig(this.getParserConfig());
                parser.setParseErrorListener(new ParseErrorLogger());
                parser.setRDFHandler(handler);
                parser.parse(response.getEntity().getContent(), method.getURI().toASCIIString());
            }
            catch (RDFParseException e) {
                throw new RepositoryException("Malformed query result from server", e);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private HttpResponse sendGraphQueryViaHttp(HttpUriRequest method, boolean requireContext, Set<RDFFormat> rdfFormats) throws RepositoryException, IOException, QueryInterruptedException, MalformedQueryException {
        List<String> acceptParams = RDFFormat.getAcceptParams(rdfFormats, requireContext, this.getPreferredRDFFormat());
        method.addHeader("Accept", String.join((CharSequence)", ", acceptParams));
        try {
            return this.executeOK(method);
        }
        catch (MalformedQueryException | QueryInterruptedException | RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    protected boolean getBoolean(HttpUriRequest method) throws IOException, RDF4JException {
        Set<QueryResultFormat> booleanFormats = BooleanQueryResultParserRegistry.getInstance().getKeys();
        if (booleanFormats.isEmpty()) {
            throw new RepositoryException("No boolean query result parsers have been registered");
        }
        HttpResponse response = this.sendBooleanQueryViaHttp(method, booleanFormats);
        try {
            String mimeType = this.getResponseMIMEType(response);
            try {
                QueryResultFormat format = BooleanQueryResultFormat.matchMIMEType(mimeType, booleanFormats).orElseThrow(() -> new RepositoryException("Server responded with an unsupported file format: " + mimeType));
                BooleanQueryResultParser parser = QueryResultIO.createBooleanParser(format);
                QueryResultCollector results = new QueryResultCollector();
                parser.setQueryResultHandler(results);
                parser.parseQueryResult(response.getEntity().getContent());
                boolean bl = results.getBoolean();
                return bl;
            }
            catch (QueryResultParseException e) {
                throw new RepositoryException("Malformed query result from server", e);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private HttpResponse sendBooleanQueryViaHttp(HttpUriRequest method, Set<QueryResultFormat> booleanFormats) throws IOException, RDF4JException {
        ArrayList<String> acceptValues = new ArrayList<String>(booleanFormats.size());
        for (QueryResultFormat format : booleanFormats) {
            int qValue = 10;
            if (this.preferredBQRFormat != null && !this.preferredBQRFormat.equals(format)) {
                qValue -= 2;
            }
            Iterator<String> iterator = format.getMIMETypes().iterator();
            while (iterator.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = iterator.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                acceptValues.add(acceptParam);
            }
        }
        method.addHeader("Accept", String.join((CharSequence)", ", acceptValues));
        return this.executeOK(method);
    }

    protected HttpResponse executeOK(HttpUriRequest method) throws IOException, RDF4JException {
        boolean fail = true;
        HttpResponse response = this.execute(method);
        try {
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode == 200 || httpCode == 203) {
                fail = false;
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            throw new RepositoryException("Failed to get server protocol; no such resource on this server: " + method.getURI().toString());
        }
        finally {
            if (fail) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    protected void executeNoContent(HttpUriRequest method) throws IOException, RDF4JException {
        HttpResponse response = this.execute(method);
        try {
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new RepositoryException("Failed to get server protocol; no such resource on this server: " + method.getURI().toString());
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    protected HttpResponse execute(HttpUriRequest method) throws IOException, RDF4JException {
        boolean consume = true;
        if (this.params != null) {
            method.setParams(this.params);
        }
        HttpResponse response = this.httpClient.execute(method, (HttpContext)this.httpContext);
        try {
            int httpCode = response.getStatusLine().getStatusCode();
            if (httpCode >= 200 && httpCode < 300 || httpCode == 404) {
                consume = false;
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            switch (httpCode) {
                case 401: {
                    throw new UnauthorizedException();
                }
                case 503: {
                    throw new QueryInterruptedException();
                }
            }
            ErrorInfo errInfo = this.getErrorInfo(response);
            if (errInfo.getErrorType() == ErrorType.MALFORMED_DATA) {
                throw new RDFParseException(errInfo.getErrorMessage());
            }
            if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_FILE_FORMAT) {
                throw new UnsupportedRDFormatException(errInfo.getErrorMessage());
            }
            if (errInfo.getErrorType() == ErrorType.MALFORMED_QUERY) {
                throw new MalformedQueryException(errInfo.getErrorMessage());
            }
            if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_QUERY_LANGUAGE) {
                throw new UnsupportedQueryLanguageException(errInfo.getErrorMessage());
            }
            if (errInfo.toString().length() > 0) {
                throw new RepositoryException(errInfo.toString());
            }
            throw new RepositoryException(response.getStatusLine().getReasonPhrase());
        }
        finally {
            if (consume) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    protected String getResponseMIMEType(HttpResponse method) throws IOException {
        Header[] headers;
        for (Header header : headers = method.getHeaders("Content-Type")) {
            HeaderElement[] headerElements;
            for (HeaderElement headerEl : headerElements = header.getElements()) {
                String mimeType = headerEl.getName();
                if (mimeType == null) continue;
                this.logger.debug("reponse MIME type is {}", (Object)mimeType);
                return mimeType;
            }
        }
        return null;
    }

    protected ErrorInfo getErrorInfo(HttpResponse response) throws RepositoryException {
        try {
            ErrorInfo errInfo = ErrorInfo.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
            this.logger.warn("Server reports problem: {}", (Object)errInfo.getErrorMessage());
            return errInfo;
        }
        catch (IOException e) {
            this.logger.warn("Unable to retrieve error info from server");
            throw new RepositoryException("Unable to retrieve error info from server", e);
        }
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public long getConnectionTimeout() {
        if (this.params == null) {
            return 0L;
        }
        return this.params.getIntParameter("http.socket.timeout", 0);
    }

    public void setConnectionTimeout(long timeout) {
        if (this.params == null) {
            this.params = new BasicHttpParams();
        }
        this.params.setIntParameter("http.socket.timeout", (int)timeout);
    }
}

