/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text;

import com.opencsv.bean.BeanField;
import com.opencsv.bean.MappingStrategy;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;

public abstract class SPARQLResultsXSVMappingStrategy
implements MappingStrategy<BindingSet> {
    protected List<String> bindingNames = null;
    protected final ValueFactory valueFactory;
    protected static final Pattern numberPattern = Pattern.compile("^[-+]?[\\d.].*");
    private static final String WRITING_UNSUPPORTED = "This mapping strategy does not write.";

    public SPARQLResultsXSVMappingStrategy(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public List<String> getBindingNames() {
        return this.bindingNames;
    }

    @Deprecated
    public PropertyDescriptor findDescriptor(int col) {
        return null;
    }

    @Deprecated
    public BeanField<BindingSet> findField(int col) {
        return null;
    }

    @Deprecated
    public int findMaxFieldIndex() {
        return 0;
    }

    @Deprecated
    public BindingSet createBean() {
        return null;
    }

    public String[] generateHeader(BindingSet bean) {
        throw new UnsupportedOperationException(WRITING_UNSUPPORTED);
    }

    @Deprecated
    public Integer getColumnIndex(String name) {
        return null;
    }

    public boolean isAnnotationDriven() {
        return true;
    }

    protected Value parseNumberPatternMatch(String valueString) {
        IRI dataType = null;
        if (XMLDatatypeUtil.isValidInteger(valueString)) {
            dataType = XMLDatatypeUtil.isValidNegativeInteger(valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
        } else if (XMLDatatypeUtil.isValidDecimal(valueString)) {
            dataType = XMLSchema.DECIMAL;
        } else if (XMLDatatypeUtil.isValidDouble(valueString)) {
            dataType = XMLSchema.DOUBLE;
        }
        return dataType != null ? this.valueFactory.createLiteral(valueString, dataType) : this.valueFactory.createLiteral(valueString);
    }

    @Deprecated
    public BindingSet populateNewBeanWithIntrospection(String[] line) {
        throw new UnsupportedOperationException("Please use populateNewBean() instead.");
    }

    @Deprecated
    public void verifyLineLength(int numberOfFields) {
    }

    public void setErrorLocale(Locale errorLocale) {
    }

    public void setType(Class<? extends BindingSet> type) {
    }

    public String[] transmuteBean(BindingSet bean) {
        throw new UnsupportedOperationException(WRITING_UNSUPPORTED);
    }
}

